package com.bokesoft.yes.meta.persist.dom.form.component.view.layout;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.def.DefSize;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.form.component.view.layout.MetaLayoutRow;

public class MetaLayoutRowAction extends BaseDomAction<MetaLayoutRow> {

	@Override
	public void load(Document document, Element element, MetaLayoutRow meta, int runType) {
		meta.setHeight(DefSize.parse(DomHelper.readAttr(element, MetaConstants.COMMON_HEIGHT, DefSize.STR_Pref)));
	}

	@Override
	public void save(Document document, Element element, MetaLayoutRow meta, int runType) {
		DefSize height = meta.getHeight();
		if ( height != null ) {
			DomHelper.writeAttr(element, MetaConstants.COMMON_HEIGHT, height.toString(), DefSize.STR_Pref);
		}
	}

}
