package com.bokesoft.yes.meta.persist.dom.form.component.panel;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yes.meta.persist.dom.form.component.MetaComponentExtAction;
import com.bokesoft.yigo.common.def.DefSize;
import com.bokesoft.yigo.common.def.SlidingPosition;
import com.bokesoft.yigo.common.def.SlidingType;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.form.component.panel.MetaSlidingLayoutPanel;

public class MetaSlidingLayoutPanelExtAction extends MetaComponentExtAction<MetaSlidingLayoutPanel>{

	@Override
	public void load(Document document, Element element, MetaSlidingLayoutPanel meta, int runType) {
		super.load(document, element, meta, runType);
		meta.setStyle(SlidingType.parse(DomHelper.readAttr(element, MetaConstants.SLIDING_STYLE, "")));
		meta.setSlidingPosition(SlidingPosition.parse(DomHelper.readAttr(element, MetaConstants.SLIDING_POSITION, "")));
		meta.setLeftWidth(DefSize.parse(DomHelper.readAttr(element, MetaConstants.SLIDING_LEFTWIDTH, null)));
		meta.setRightWidth(DefSize.parse(DomHelper.readAttr(element, MetaConstants.SLIDING_RIGHTWIDTH, null)));
	}
}
