package com.bokesoft.yes.meta.persist.dom.form.component.grid;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.common.MetaBaseScriptAction;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.form.component.grid.MetaRowGroup;

public class MetaRowGroupAction extends MetaBaseScriptAction<MetaRowGroup>{

	@Override
	public void load(Document document, Element element, MetaRowGroup meta, int runType) {
		super.load(document, element, meta, runType);
		meta.setItemKey(DomHelper.readAttr(element, MetaConstants.ITEM_KEY, ""));
		meta.setItemMask(DomHelper.readAttr(element, MetaConstants.ITEMMASK, ""));
		meta.setTag(DomHelper.readAttr(element, MetaConstants.TAG, ""));
	}

	@Override
	public void save(Document document, Element element, MetaRowGroup meta, int runType) {
		super.save(document, element, meta, runType);
		DomHelper.writeAttr(element, MetaConstants.ITEM_KEY, meta.getItemKey(), "");
		DomHelper.writeAttr(element, MetaConstants.ITEMMASK, meta.getItemMask(), "");
		DomHelper.writeAttr(element, MetaConstants.TAG, meta.getTag(), "");
	}
	
}
