package com.bokesoft.yes.meta.persist.dom.form.component.grid;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.def.ColumnType;
import com.bokesoft.yigo.common.def.DefSize;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.form.component.grid.MetaGridColumn;


public class MetaGridColumnExtAction extends BaseDomAction<MetaGridColumn> {
	
	@Override
	public void load(Document document, Element element, MetaGridColumn meta, int runType) {
		String key = DomHelper.readAttr(element, MetaConstants.COMMON_KEY, "");
		meta.setKey(key);
		meta.setOldKey(key);
		meta.setMetaKey(key);

		meta.setWidth(DefSize.parse(DomHelper.readAttr(element, MetaConstants.COMMON_WIDTH, "")));
		meta.setSortable(DomHelper.readBool(element, MetaConstants.SORTABLE, null));

		meta.setVisible(DomHelper.readAttr(element, MetaConstants.COMMON_VISIBLE, null));
		meta.setEnable(DomHelper.readAttr(element, MetaConstants.COMMON_ENABLE, null));
		
		meta.setEnableDependency(DomHelper.readAttr(element, MetaConstants.COMMON_ENABLE_DEPENDENCY, null));
		meta.setVisibleDependency(DomHelper.readAttr(element, MetaConstants.COMMON_VISIBLE_DEPENDENCY, null));
		
		meta.setColumnType(ColumnType.parse(DomHelper.readAttr(element, MetaConstants.COLUMN_TYPE, "")));
		meta.setCaption(DomHelper.readAttr(element, MetaConstants.COMMON_CAPTION, null));
		meta.setCaptionFull(DomHelper.readAttr(element, MetaConstants.COMMON_CAPTION_FULL, null));
		meta.setCaptionEn(DomHelper.readAttr(element, MetaConstants.COMMON_CAPTION_EN, null));
		meta.setCaptionEnFull(DomHelper.readAttr(element, MetaConstants.COMMON_CAPTION_EN_FULL, null));
		meta.setFormulaCaption(DomHelper.readAttr(element, MetaConstants.FORMULA_CAPTION, null));
		meta.setAutoCaption(DomHelper.readBool(element, MetaConstants.AUTO_CAPTION, null));
		meta.setFrozen(DomHelper.readBool(element, MetaConstants.COMMON_FREEZE, null));
		meta.setFixed(DomHelper.readAttr(element, MetaConstants.COMMON_FIXED, null));
		meta.setImage(DomHelper.readAttr(element, MetaConstants.IMAGE, null));
		meta.setSumFormula(DomHelper.readAttr(element, MetaConstants.SUMFORMULA, null));
		meta.setSideKey(DomHelper.readAttr(element, "SideKey", ""));

		meta.setInsertAfter(DomHelper.readBool(element, "InsertAfter", true));
		meta.setFirst(DomHelper.readBool(element, "First", false));
		meta.setLast(DomHelper.readBool(element, "Last", false));
		meta.setGroupSumFormula(DomHelper.readAttr(element, MetaConstants.GROUPSUMFORMULA, null));
	}
	
	@Override
	public void save(Document document, Element element, MetaGridColumn meta, int runType) {

	}

}
