package com.bokesoft.yes.meta.persist.dom.form.component.grid;

import java.util.HashMap;

import com.bokesoft.yes.meta.persist.dom.form.component.control.properties.extend.*;
import org.apache.commons.lang3.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yes.meta.persist.dom.form.component.control.MetaDynamicPropertiesAction;
import com.bokesoft.yes.meta.persist.dom.form.component.control.properties.MetaCheckBoxPropertiesAction;
import com.bokesoft.yes.meta.persist.dom.form.component.control.properties.MetaCustomPropertiesAction;
import com.bokesoft.yes.meta.persist.dom.form.component.control.properties.MetaDictPropertiesAction;
import com.bokesoft.yes.meta.persist.dom.form.component.control.properties.MetaHyperLinkPropertiesAction;
import com.bokesoft.yes.meta.persist.dom.form.component.control.properties.MetaMonthPickerPropertiesAction;
import com.bokesoft.yes.meta.persist.dom.form.component.control.properties.MetaTimePickerPropertiesAction;
import com.bokesoft.yigo.common.def.CellType;
import com.bokesoft.yigo.common.def.ControlType;
import com.bokesoft.yigo.common.def.GroupType;
import com.bokesoft.yigo.common.def.SortType;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaDictProperties;
import com.bokesoft.yigo.meta.form.component.grid.MetaGridCell;

public class MetaGridCellExtAction extends BaseDomAction<MetaGridCell> {
    private HashMap<Integer, BaseDomAction<AbstractMetaObject>> actionMap = null;

    @SuppressWarnings("unchecked")
    public MetaGridCellExtAction() {
        super();
        actionMap = new HashMap<Integer, BaseDomAction<AbstractMetaObject>>();
        Object[][] v = new Object[][] {
                { ControlType.LABEL, new MetaLabelExtPropertiesAction() },
                { ControlType.PRICELABEL, new MetaPriceLabelExtPropertiesAction() },
                { ControlType.RELATIVETIME, new MetaRelativeTimeExtPropertiesAction() },
                { ControlType.BUTTON, new MetaButtonExtPropertiesAction() },
                { ControlType.NOTICEBAR, new MetaNoticeBarExtPropertiesAction() },
                { ControlType.BARCODER, new MetaBarCoderExtPropertiesAction() },
                { ControlType.TEXTEDITOR, new MetaTextEditorExtPropertiesAction() },
                { ControlType.TEXTBUTTON, new MetaTextButtonExtPropertiesAction() },
                { ControlType.NUMBEREDITOR, new MetaNumberEditorExtPropertiesAction() },
                { ControlType.DICT, new MetaDictExtPropertiesAction() },
                { ControlType.DATEPICKER, new MetaDatePickerExtPropertiesAction() },
                { ControlType.UTCDATEPICKER, new MetaUTCDatePickerExtPropertiesAction()},
                { ControlType.COMBOBOX, new MetaComboBoxExtPropertiesAction() },
                { ControlType.CHECKLISTBOX, new MetaCheckListBoxExtPropertiesAction() },
                { ControlType.IMAGE, new MetaImageExtPropertiesAction() },
                { ControlType.VIDEOPLAYER, new MetaVideoPlayerExtPropertiesAction() },
                { ControlType.TEXTAREA, new MetaTextAreaExtPropertiesAction() },
                { ControlType.DYNAMIC, new MetaDynamicPropertiesAction() },
                { ControlType.HYPERLINK, new MetaHyperLinkExtPropertiesAction() },
                { ControlType.CHECKBOX, new MetaCheckBoxExtPropertiesAction() },
                { ControlType.DYNAMICDICT,new MetaDynamicDictExtPropertiesAction()},
                { ControlType.COMPDICT,new MetaDictExtPropertiesAction()},
                { ControlType.MONTHPICKER, new MetaMonthPickerExtPropertiesAction() },
                { ControlType.TIMEPICKER, new MetaTimePickerExtPropertiesAction() },

                // 暂不继承
                { ControlType.CUSTOM, new MetaCustomPropertiesAction() }

        };
        int length = v.length;
        for ( int i = 0; i<length; ++i ) {
            Object[] l = v[i];
            Integer type = (Integer)l[0];
            BaseDomAction<AbstractMetaObject> action = (BaseDomAction<AbstractMetaObject>)l[1];
            actionMap.put(type, action);
        }
    }

    @Override
    public void load(Document document, Element element, MetaGridCell meta, int runType) {
        meta.setKey(DomHelper.readAttr(element, MetaConstants.COMMON_KEY, ""));
        meta.setCaption(DomHelper.readAttr(element, MetaConstants.COMMON_CAPTION, null));
        meta.setCaptionFull(DomHelper.readAttr(element, MetaConstants.COMMON_CAPTION_FULL, null));
        meta.setCaptionEn(DomHelper.readAttr(element, MetaConstants.COMMON_CAPTION_EN, null));
        meta.setCaptionEnFull(DomHelper.readAttr(element, MetaConstants.COMMON_CAPTION_EN_FULL, null));
        meta.setEnable(DomHelper.readAttr(element, MetaConstants.COMMON_ENABLE, null));
        meta.setEnableDependency(DomHelper.readAttr(element, MetaConstants.COMMON_ENABLE_DEPENDENCY, null));
        meta.setCellType(CellType.parse(DomHelper.readAttr(element, MetaConstants.CELL_TYPE, ControlType.STR_LABEL)));
        meta.setIsMerged(DomHelper.readBool(element, MetaConstants.IS_MERGED, null));
        meta.setIsMergedHead(DomHelper.readBool(element, MetaConstants.IS_MERGED_HEAD, null));
        meta.setMergedRowSpan(DomHelper.readAttr(element, MetaConstants.MERGED_ROW_SPAN, -1));
        meta.setMergedColumnSpan(DomHelper.readAttr(element, MetaConstants.MERGED_COLUMN_SPAN, -1));
        meta.setCellGroupType(GroupType.parse(DomHelper.readAttr(element, MetaConstants.CELL_GROUP_TYPE, "")));
        meta.setMerge(DomHelper.readBool(element, MetaConstants.MERGE, null));
        meta.setMergeGroup(DomHelper.readBool(element, MetaConstants.MERGEGROUP, null));

        meta.setSelect(DomHelper.readBool(element, MetaConstants.IS_SELECT, null));
        meta.setSingleSelect(DomHelper.readBool(element, MetaConstants.SINGLE_SELECT, null));
        String cssClass = DomHelper.readAttr(element, MetaConstants.COMPONENT_CLASS, null);
        if (StringUtils.isBlank(cssClass)) {
            cssClass = DomHelper.readAttr(element, MetaConstants.OPERATION_CSSCLASS, null);
        }
        meta.setCssClass(cssClass);
        meta.setForeColor(DomHelper.readAttr(element, MetaConstants.COMMON_FORECOLOR, null));
        meta.setBackColor(DomHelper.readAttr(element, MetaConstants.COMMON_BACKCOLOR, null));
        meta.setCellSortType(SortType.parse(DomHelper.readAttr(element, MetaConstants.CELL_SORTYPE, "")));
        meta.setCellGroupItemKey(DomHelper.readAttr(element, MetaConstants.CELL_GROUPITEMKEY, null));

        meta.setAsQuery(DomHelper.readBool(element, MetaConstants.COMPONENT_ASQUERY, null));
        meta.setCopyNew(DomHelper.readBool(element, MetaConstants.COMPONENT_COPYNEW, null));
        meta.setToolTip(DomHelper.readAttr(element, MetaConstants.COMPONENT_TOOLTIP, null));
        meta.setFormulaTip(DomHelper.readAttr(element, MetaConstants.COMPONENT_FORMULATIP, null));
        meta.setSideKey(DomHelper.readAttr(element, "SideKey", ""));
        meta.setInsertAfter(DomHelper.readBool(element, "InsertAfter", true));
        meta.setFirst(DomHelper.readBool(element, "First", false));
        meta.setLast(DomHelper.readBool(element, "Last", false));
        //属性
        meta.ensureProperties();
        //加载属性
        BaseDomAction<AbstractMetaObject> action = actionMap.get(meta.getCellType());
        if ( action != null ) {
            action.load(document, element, meta.getProperties(), runType);
            if(meta.getCellType() == ControlType.COMPDICT){
                MetaDictProperties dictPro = (MetaDictProperties) meta.getProperties();
                dictPro.setCompDict(true);
            }else if(meta.getCellType() == ControlType.DYNAMICDICT){
                MetaDictProperties dictPro = (MetaDictProperties) meta.getProperties();
                dictPro.setDynamic(true);
            }
        }
    }

    @Override
    public void save(Document document, Element element, MetaGridCell meta, int runType) {

    }

}