package com.bokesoft.yes.meta.persist.dom.form.component.control.treeview;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yes.meta.persist.dom.form.component.MetaComponentAction;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.form.component.control.treeview.MetaTreeView;

public class MetaTreeViewAction extends MetaComponentAction<MetaTreeView> {
	@Override
	public void load(Document document, Element element, MetaTreeView meta, int runType) {
		super.load(document, element, meta, runType);
		meta.setTreeColumnKey(DomHelper.readAttr(element, MetaConstants.TREEVIEW_TREECOLUMNKEY, ""));
		meta.setTableKey(DomHelper.readAttr(element, MetaConstants.DATABINDING_TABLEKEY, ""));
	}

	@Override
	public void save(Document document, Element element, MetaTreeView meta, int runType) {
		super.save(document, element, meta, runType);
		DomHelper.writeAttr(element, MetaConstants.TREEVIEW_TREECOLUMNKEY, meta.getTreeColumnKey(), "");
		DomHelper.writeAttr(element, MetaConstants.DATABINDING_TABLEKEY, meta.getTableKey(), "");
	}
}
