package com.bokesoft.yes.meta.persist.dom.form.component.control.properties.extend;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yes.meta.persist.dom.form.component.control.properties.DomPropertiesAction;
import com.bokesoft.yigo.common.def.CountDownViewStyle;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaCountDownViewProperties;

public class MetaCountDownViewExtPropertiesAction extends DomPropertiesAction<MetaCountDownViewProperties> {

	@Override
	public void loadImpl(Document document, Element element, MetaCountDownViewProperties meta, int runType) {
		meta.setStepper(DomHelper.readAttr(element, MetaConstants.COUNTDOWN_STEPPER, -1));
		meta.setRepeat(DomHelper.readBool(element, MetaConstants.COUNTDOWN_REPEAT, null));
		meta.setMaxTime(DomHelper.readAttr(element, MetaConstants.COUNTDOWN_MAXTIME, -1));
		meta.setStyle(CountDownViewStyle.parse(DomHelper.readAttr(element, MetaConstants.COUNTDOWN_STYLE, "")));
	}

	@Override
	public void saveImpl(Document document, Element element, MetaCountDownViewProperties meta, int runType) {
		// TODO Auto-generated method stub
		
	}

}
