package com.bokesoft.yes.meta.persist.dom.form.component.control.properties;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.def.SelectEditType;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaTimePickerProperties;

public class MetaTimePickerPropertiesAction extends DomPropertiesAction<MetaTimePickerProperties> {

	@Override
	public void loadImpl(Document document, Element element, MetaTimePickerProperties meta, int runType) {
		meta.setDateFormat(DomHelper.readAttr(element, MetaConstants.TIMEPICKER_FORMAT, null));
		meta.setSecond(DomHelper.readAttr(element, MetaConstants.TIMEPICKER_SECOND, false));
		meta.setPromptText(DomHelper.readAttr(element, MetaConstants.TIMEPICKER_PROMPTTEXT, ""));
		meta.setEditType(SelectEditType.parse(DomHelper.readAttr(element, MetaConstants.TIMEPICKER_EDITTYPE, SelectEditType.STR_POP)));
		
	}

	@Override
	public void saveImpl(Document document, Element element, MetaTimePickerProperties meta, int runType) {
		DomHelper.writeAttr(element, MetaConstants.TIMEPICKER_FORMAT, meta.getDateFormat(), null);
		DomHelper.writeAttr(element, MetaConstants.TIMEPICKER_SECOND, meta.isSecond(), false);
		DomHelper.writeAttr(element, MetaConstants.TIMEPICKER_PROMPTTEXT, meta.getPromptText(), "");
		DomHelper.writeAttr(element, MetaConstants.TIMEPICKER_EDITTYPE, SelectEditType.format(meta.getEditType()), SelectEditType.STR_POP);
		
	}

	

}
