package com.bokesoft.yes.meta.persist.dom.form.component.control.properties;

import java.math.BigDecimal;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.def.StepEditorEditType;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaStepEditorProperties;

public class MetaStepEditorPropertiesAction extends DomPropertiesAction<MetaStepEditorProperties> {

	@Override
	public void loadImpl(Document document, Element element, MetaStepEditorProperties meta, int runType) {
		String minValue = DomHelper.readAttr(element, MetaConstants.STEPEDITOR_MINVALUE, "");
		if (minValue != null && !minValue.isEmpty()) {
			meta.setMinValue(TypeConvertor.toBigDecimal(minValue));
		}
		String maxValue = DomHelper.readAttr(element, MetaConstants.STEPEDITOR_MAXVALUE, "");
		if (maxValue != null && !maxValue.isEmpty()) {
			meta.setMaxValue(TypeConvertor.toBigDecimal(maxValue));
		}
		String step = DomHelper.readAttr(element, MetaConstants.STEPEDITOR_STEP, "");
		if(step != null && !step.isEmpty()){
			meta.setStep(TypeConvertor.toBigDecimal(step));
		}
		meta.setEditType(StepEditorEditType
				.parse(DomHelper.readAttr(element, MetaConstants.STEPEDITOR_EDITTYPE, StepEditorEditType.STR_INPUT)));

		meta.setShowType(meta.parseShowType(DomHelper.readAttr(element, MetaConstants.STEPEDITOR_SHOWTYPE, "")));
		meta.setDisableKeyboard(DomHelper.readBool(element, MetaConstants.STEPEDITOR_DISABLEKEYBOARD, null));
	}

	@Override
	public void saveImpl(Document document, Element element, MetaStepEditorProperties meta, int runType) {
		DomHelper.writeAttr(element, MetaConstants.STEPEDITOR_MINVALUE, meta.getMinValue().toString(),
				new BigDecimal(Long.MIN_VALUE).toString());
		DomHelper.writeAttr(element, MetaConstants.STEPEDITOR_MAXVALUE, meta.getMaxValue().toString(),
				new BigDecimal(Long.MAX_VALUE).toString());
		DomHelper.writeAttr(element, MetaConstants.STEPEDITOR_STEP, meta.getStep().toString(),
				BigDecimal.ONE.toString());
		DomHelper.writeAttr(element, MetaConstants.STEPEDITOR_EDITTYPE, StepEditorEditType.format(meta.getEditType()),
				StepEditorEditType.STR_INPUT);
		DomHelper.writeAttr(element, MetaConstants.STEPEDITOR_SHOWTYPE, meta.getShowTypeStr(meta.getShowType()),
				"");
		if(meta.isDisableKeyboard() != null){
			DomHelper.writeAttr(element, MetaConstants.STEPEDITOR_DISABLEKEYBOARD, meta.isDisableKeyboard().toString(), "");
		}
	}

}