package com.bokesoft.yes.meta.persist.dom.form.component.control.properties;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.def.ComboBoxSourceType;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaSegmentedControlProperties;

public class MetaSegmentedControlPropertiesAction extends DomPropertiesAction<MetaSegmentedControlProperties> {

	@Override
	public void loadImpl(Document document, Element element, MetaSegmentedControlProperties meta, int runType) {
		meta.setEditable(DomHelper.readAttr(element, MetaConstants.COMBOBOX_EDITABLE, false));
		meta.setDynamicItems(DomHelper.readAttr(element, MetaConstants.COMBOBOX_DYNAMICITEMS, false));
		meta.setItemsDependency(DomHelper.readAttr(element, MetaConstants.COMBOBOX_ITEMS_DEPENDENCY, ""));
		meta.setSourceType(ComboBoxSourceType.parse(DomHelper.readAttr(element, MetaConstants.COMBOBOX_SOURCETYPE, ComboBoxSourceType.STR_ITEMS)));
		meta.setGroupKey(DomHelper.readAttr(element, MetaConstants.COMBOBOX_GROUPKEY, ""));
		meta.setGlobalItems(DomHelper.readAttr(element, MetaConstants.COMBOBOX_GLOBAL_ITEMS, ""));
		meta.setIntegerValue(DomHelper.readAttr(element, MetaConstants.COMBOBOX_INTEGER_VALUE, false));
	}

	@Override
	public void saveImpl(Document document, Element element, MetaSegmentedControlProperties meta, int runType) {
		DomHelper.writeAttr(element, MetaConstants.COMBOBOX_EDITABLE, meta.isEditable(), false);
		DomHelper.writeAttr(element, MetaConstants.COMBOBOX_DYNAMICITEMS, meta.isDynamicItems(), false);
		DomHelper.writeAttr(element, MetaConstants.COMBOBOX_ITEMS_DEPENDENCY, meta.getItemsDependency(), "");
		DomHelper.writeAttr(element, MetaConstants.COMBOBOX_SOURCETYPE, ComboBoxSourceType.format(meta.getSourceType()), ComboBoxSourceType.STR_ITEMS);
		DomHelper.writeAttr(element, MetaConstants.COMBOBOX_GROUPKEY, meta.getGroupKey(), "");
		DomHelper.writeAttr(element, MetaConstants.COMBOBOX_GLOBAL_ITEMS, meta.getGlobalItems(), "");
		DomHelper.writeAttr(element, MetaConstants.COMBOBOX_INTEGER_VALUE, meta.isIntegerValue(), false);
	}

}
