package com.bokesoft.yes.meta.persist.dom.form.component.control.properties;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaScoreBarProperties;

public class MetaScoreBarPropertiesAction extends DomPropertiesAction<MetaScoreBarProperties> {
	@Override
	public void loadImpl(Document document, Element element,
			MetaScoreBarProperties meta, int runType) {
		meta.setCount(DomHelper.readAttr(element, MetaConstants.SCOREBAR_COUNT, 5));
		meta.setIcon(DomHelper.readAttr(element, MetaConstants.SCOREBAR_ICON, ""));
		meta.setSelectIcon(DomHelper.readAttr(element, MetaConstants.SCOREBAR_SELECTICON, ""));
		meta.setSupportHalf(DomHelper.readAttr(element, MetaConstants.SCOREBAR_SUPPORTHALF, true));
	}

	@Override
	public void saveImpl(Document document, Element element,
			MetaScoreBarProperties meta, int runType) {
		DomHelper.writeAttr(element, MetaConstants.SCOREBAR_COUNT, meta.getCount(), 5);
		DomHelper.writeAttr(element, MetaConstants.SCOREBAR_ICON, meta.getIcon(), "");
		DomHelper.writeAttr(element, MetaConstants.SCOREBAR_SELECTICON, meta.getSelectIcon(), "");
		DomHelper.writeAttr(element, MetaConstants.SCOREBAR_SUPPORTHALF, meta.isSupportHalf(), true);
	}

}