package com.bokesoft.yes.meta.persist.dom.form.component.control.properties;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaRelativeTimeProperties;

public class MetaRelativeTimePropertiesAction extends DomPropertiesAction<MetaRelativeTimeProperties> {

	@Override
	public void loadImpl(Document document, Element element, MetaRelativeTimeProperties meta, int runType) {
		meta.setInterval(DomHelper.readAttr(element, MetaConstants.RELATIVETIME_INTERVAL, 60));
	}

	@Override
	public void saveImpl(Document document, Element element, MetaRelativeTimeProperties meta, int runType) {
		DomHelper.writeAttr(element, MetaConstants.RELATIVETIME_INTERVAL, meta.getInterval(), 60);
	}
}
