package com.bokesoft.yes.meta.persist.dom.form.component.control.properties;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;

public class MetaDynamicProperties extends AbstractMetaObject {
	
	private String typeFormula = "";
	
	private String typeDependency = "";
	
	private List<String> dependencyFields = new ArrayList<String>();
	
	public MetaDynamicProperties() {
	}

	@Override
	public void getChildMetaObjects(LinkedList<Object> list) {
		
	}

	@Override
	public String getTagName() {
		
		return null;
	}

	@Override
	public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag,
			int runType) throws MetaException {

		return null;
	}

	@Override
	public AbstractMetaObject clone() {
		MetaDynamicProperties newObj = new MetaDynamicProperties();
		newObj.setTypeFormula(typeFormula);
		newObj.setTypeDependency(typeDependency);
		return newObj;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaDynamicProperties();
	}
	
	/**
	 * 获取类型表达式
	 * @return 表达式
	 */
	public String getTypeFormula() {
		return typeFormula;
	}

	/**
	 * 设置类型表达式
	 * @param typeFormula 表达式
	 */
	public void setTypeFormula(String typeFormula) {
		this.typeFormula = typeFormula;
	}

	/**
	 * 获取类型依赖的字段
	 * @return
	 */
	public String getTypeDependency() {
		return typeDependency;
	}

	/**
	 * 获取依赖域集合
	 * @return
	 */
	public List<String> getDependFields() {
		return dependencyFields;
	}

	/**
	 * 设置类型依赖的字段
	 * @param typeDependency
	 */
	public void setTypeDependency(String typeDependency) {
		this.typeDependency = typeDependency;
		
		if( !typeDependency.isEmpty() ) {
			String[] array = typeDependency.split(",");
			for( int i = 0; i< array.length;i++ ) {
				dependencyFields.add(array[i]);
			}
		}
	}

}
