package com.bokesoft.yes.meta.persist.dom.form.component.control.properties;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.def.CountDownViewStyle;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaCountDownViewProperties;

public class MetaCountDownViewPropertiesAction extends DomPropertiesAction<MetaCountDownViewProperties>{

	@Override
	public void loadImpl(Document document, Element element, MetaCountDownViewProperties meta, int runType) {
		meta.setStepper(DomHelper.readAttr(element, MetaConstants.COUNTDOWN_STEPPER, 1));
		meta.setRepeat(DomHelper.readAttr(element, MetaConstants.COUNTDOWN_REPEAT, false));
		meta.setMaxTime(DomHelper.readAttr(element, MetaConstants.COUNTDOWN_MAXTIME, MetaCountDownViewProperties.DEFAULT_MAX_TIMER));
		meta.setStyle(CountDownViewStyle.parse(DomHelper.readAttr(element, MetaConstants.COUNTDOWN_STYLE, CountDownViewStyle.STR_RECTANGLE)));
		meta.setEndCaption(DomHelper.readAttr(element, MetaConstants.COUNTDOWN_ENDCAPTION, ""));
	}

	@Override
	public void saveImpl(Document document, Element element, MetaCountDownViewProperties meta, int runType) {
		DomHelper.writeAttr(element, MetaConstants.COUNTDOWN_MAXTIME, meta.getMaxTime(), MetaCountDownViewProperties.DEFAULT_MAX_TIMER);
		DomHelper.writeAttr(element, MetaConstants.COUNTDOWN_REPEAT, meta.isRepeat(), false);
		DomHelper.writeAttr(element, MetaConstants.COUNTDOWN_STEPPER, meta.getStepper(), 1);
		DomHelper.writeAttr(element, MetaConstants.COUNTDOWN_STYLE, CountDownViewStyle.toString(meta.getStyle()), CountDownViewStyle.STR_RECTANGLE);
		DomHelper.writeAttr(element, MetaConstants.COUNTDOWN_ENDCAPTION, meta.getEndCaption(), "");
	}

}
