package com.bokesoft.yes.meta.persist.dom.form.component.control.properties;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.form.component.control.properties.MetaBPMGraphProperties;

public class MetaBPMGraphPropertiesAction extends DomPropertiesAction<MetaBPMGraphProperties> {

	@Override
	public void loadImpl(Document document, Element element,
			MetaBPMGraphProperties meta, int runType) {
		meta.setViewTag(DomHelper.readAttr(element, MetaConstants.BPMGRAPH_VIEWTAG, ""));
		meta.setTableKey(DomHelper.readAttr(element, MetaConstants.BPMGRAPH_TABLEKEY, ""));
		meta.setProcessKey(DomHelper.readAttr(element, MetaConstants.BPMGRAPH_PROCESSKEY, ""));
		meta.setProcessVer(DomHelper.readAttr(element, MetaConstants.BPMGRAPH_PROCESSVER, ""));
		meta.setProcessPath(DomHelper.readAttr(element, MetaConstants.BPMGRAPH_PROCESSPATH, ""));
		meta.setOID(DomHelper.readAttr(element, MetaConstants.COMMON_OID, ""));
	}

	@Override
	public void saveImpl(Document document, Element element,
			MetaBPMGraphProperties meta, int runType) {
		DomHelper.writeAttr(element, MetaConstants.BPMGRAPH_VIEWTAG, meta.getViewTag(), "");
		DomHelper.writeAttr(element, MetaConstants.BPMGRAPH_TABLEKEY, meta.getTableKey(), "");
		DomHelper.writeAttr(element, MetaConstants.BPMGRAPH_PROCESSKEY, meta.getProcessKey(), "");
		DomHelper.writeAttr(element, MetaConstants.BPMGRAPH_PROCESSVER, meta.getProcessVer(), "");
		DomHelper.writeAttr(element, MetaConstants.BPMGRAPH_PROCESSPATH, meta.getProcessPath(), "");
		DomHelper.writeAttr(element, MetaConstants.COMMON_OID, meta.getOID(), "");
	}

}
