package com.bokesoft.yes.meta.persist.dom.form.component.control.gantt;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.form.component.control.gantt.MetaGanttRowCollection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class MetaGanttRowCollectionAction extends BaseDomAction<MetaGanttRowCollection> {

	@Override
	public void load(Document document, Element element, MetaGanttRowCollection meta, int runType) {
		meta.setTitle(DomHelper.readAttr(element, "Title", ""));
		meta.setShapeId(DomHelper.readAttr(element, "ShapeId", ""));
		meta.setType(DomHelper.readAttr(element, "Type", ""));
		meta.setDuration(DomHelper.readAttr(element, "Duration", ""));
		meta.setProgress(DomHelper.readAttr(element, "Progress", ""));
		meta.setParent(DomHelper.readAttr(element, "Parent", ""));
	}

	@Override
	public void save(Document document, Element element, MetaGanttRowCollection meta, int runType) {
		DomHelper.writeAttr(element, "Title", meta.getTitle(), "");
		DomHelper.writeAttr(element, "ShapeId", meta.getShapeId(), "");
		DomHelper.writeAttr(element, "Type", meta.getType(), "");
		DomHelper.writeAttr(element, "Duration", meta.getDuration(), "");
		DomHelper.writeAttr(element, "Progress", meta.getProgress(), "");
		DomHelper.writeAttr(element, "Parent", meta.getParent(), "");
	}

}
