package com.bokesoft.yes.meta.persist.dom.form.component.control.extend;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yes.meta.persist.dom.form.component.MetaComponentExtAction;
import com.bokesoft.yigo.common.def.OrientationType;
import com.bokesoft.yigo.common.def.PageLoadType;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.form.component.control.editview.MetaEditView;

public class MetaEditViewExtAction extends MetaComponentExtAction<MetaEditView> {
	
	@Override
	public void load(Document document, Element element, MetaEditView meta, int runType) {
		super.load(document, element, meta, runType);
		meta.setTableKey(DomHelper.readAttr(element, MetaConstants.DATABINDING_TABLEKEY, null));
		meta.setPageRowCount(DomHelper.readAttr(element, MetaConstants.EDITVIEW_PAGEROWCOUNT, -1));
		meta.setRowHeight(DomHelper.readAttr(element, MetaConstants.EDITVIEW_ROWHEIGHT, -1));
		meta.setPageLoadType(PageLoadType.parse(DomHelper.readAttr(element, MetaConstants.EDITVIEW_PAGELOADTYPE, PageLoadType.STR_NONE)));
		meta.setShowHead(DomHelper.readBool(element, MetaConstants.EDITVIEW_SHOWHEAD, null));
		meta.setDefaultSelectRow(DomHelper.readAttr(element, MetaConstants.EDITVIEW_DEFAULTSELECTROW, -1));
		meta.setPromptText(DomHelper.readAttr(element, MetaConstants.PROMPTTEXT, ""));
		meta.setPromptImage(DomHelper.readAttr(element, MetaConstants.EDITVIEW_PROMPTIMAGE, ""));
		meta.setPromptRowCount(DomHelper.readAttr(element, MetaConstants.EDITVIEW_PROMPTROWCOUNT, -1));
		meta.setItemAnim(DomHelper.readAttr(element, MetaConstants.EDITVIEW_ITEMANIM, null));
		meta.setLayoutAnim(DomHelper.readAttr(element, MetaConstants.COMPONENT_LAYOUTANIM, null));
		meta.setScrollXY(DomHelper.readBool(element, MetaConstants.EDITVIEW_SCROLLXY, null));
		meta.setOrientation(OrientationType.parse(DomHelper.readAttr(element, MetaConstants.COMPONENT_ORIENTATION, "")));
		meta.setEditRowFormKey(DomHelper.readAttr(element, MetaConstants.GRID_EDITROWFORMKEY, null));
	}

	@Override
	public void save(Document document, Element element, MetaEditView meta, int runType) {

	}

}
