package com.bokesoft.yes.meta.persist.dom.form.component.control;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.form.component.control.MetaTabItem;

public class MetaTabItemAction extends BaseDomAction<MetaTabItem> {

	@Override
	public void load(Document document, Element element, MetaTabItem meta, int runType) {
		meta.setText(DomHelper.readAttr(element, MetaConstants.COMMON_TEXT, ""));
		meta.setIcon(DomHelper.readAttr(element, MetaConstants.COMMON_ICON, ""));
		meta.setFormKey(DomHelper.readAttr(element, MetaConstants.COMMON_FORMKEY, ""));
		meta.setSelectedIcon(DomHelper.readAttr(element, MetaConstants.TABGROUP_ITEM_SELECTEDICON, ""));
		meta.setKey(DomHelper.readAttr(element, MetaConstants.COMMON_KEY, ""));
		meta.setClickAnim(DomHelper.readAttr(element, MetaConstants.COMPONENT_CLICKANIM, ""));
		meta.setVisible(DomHelper.readAttr(element, MetaConstants.COMMON_VISIBLE, ""));
		meta.setVisibleDependency(DomHelper.readAttr(element, MetaConstants.COMMON_VISIBLE_DEPENDENCY, ""));
	}

	@Override
	public void save(Document document, Element element, MetaTabItem meta, int runType) {
		DomHelper.writeAttr(element, MetaConstants.COMMON_TEXT, meta.getText(), "");
		DomHelper.writeAttr(element, MetaConstants.COMMON_ICON, meta.getIcon(), "");
		DomHelper.writeAttr(element, MetaConstants.COMMON_FORMKEY, meta.getFormKey(), "");
		DomHelper.writeAttr(element, MetaConstants.TABGROUP_ITEM_SELECTEDICON, meta.getSelectedIcon(), "");
		DomHelper.writeAttr(element, MetaConstants.COMPONENT_CLICKANIM, meta.getClickAnim(), "");
		DomHelper.writeAttr(element, MetaConstants.COMMON_KEY, meta.getKey(), "");
		DomHelper.writeAttr(element, MetaConstants.COMMON_VISIBLE, meta.getVisible(), "");
		DomHelper.writeAttr(element, MetaConstants.COMMON_VISIBLE_DEPENDENCY, meta.getVisibleDependency(), "");
	}

}
