package com.bokesoft.yes.meta.persist.dom.form.component.container;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yes.meta.persist.dom.form.component.MetaComponentAction;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.form.component.container.MetaSubDetail;

public class MetaSubDetailAction extends MetaComponentAction<MetaSubDetail> {
	@Override
	public void load(Document document, Element element, MetaSubDetail meta, int runType) {
		super.load(document, element, meta, runType);
		meta.setBindingGridKey(DomHelper.readAttr(element, MetaConstants.SUBDETAIL_BINDINGGRIDKEY, ""));
	}

	@Override
	public void save(Document document, Element element, MetaSubDetail meta, int runType) {
		super.save(document, element, meta, runType);
		DomHelper.writeAttr(element, MetaConstants.SUBDETAIL_BINDINGGRIDKEY, meta.getBindingGridKey(), "");
	}
}
