package com.bokesoft.yes.meta.persist.dom.form.component.chart;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.form.component.chart.MetaSeries;

public class MetaSeriesAction extends BaseDomAction<MetaSeries> {
	@Override
	public void load(Document document, Element element, MetaSeries meta,
			int runType) {
		meta.setDataKey(DomHelper.readAttr(element, MetaConstants.SERIES_DATA_KEY, ""));
		meta.setTitle(DomHelper.readAttr(element, MetaConstants.SERIES_TITLE, ""));
		meta.setSplitDataKey(DomHelper.readAttr(element, MetaConstants.SERIES_SPLIT_DATA_KEY, ""));
	}

	@Override
	public void save(Document document, Element element, MetaSeries meta,
			int runType) {
		DomHelper.writeAttr(element, MetaConstants.SERIES_DATA_KEY, meta.getDataKey(), "");
		DomHelper.writeAttr(element, MetaConstants.SERIES_TITLE, meta.getTitle(), "");
		DomHelper.writeAttr(element, MetaConstants.SERIES_SPLIT_DATA_KEY, meta.getSplitDataKey(), "");
	}

}
