package com.bokesoft.yes.meta.persist.dom.form.component.bar;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yes.meta.persist.dom.form.component.MetaComponentAction;
import com.bokesoft.yigo.common.def.TreeMenuBarType;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.form.component.bar.MetaTreeMenuBar;

public class MetaTreeMenuBarAction extends MetaComponentAction<MetaTreeMenuBar> {
	@Override
	public void save(Document document, Element element, MetaTreeMenuBar meta, int runType) {
		super.save(document, element, meta, runType);
		DomHelper.writeAttr(element, MetaConstants.TREEMENUBAR_TYPE, TreeMenuBarType.toString(meta.getType()), TreeMenuBarType.STR_Tree);
		DomHelper.writeAttr(element, MetaConstants.TREEMENUBAR_SOURCE, meta.getSource(), "");
		DomHelper.writeAttr(element, MetaConstants.COMMON_TAG, meta.getTag(), "");
		DomHelper.writeAttr(element, MetaConstants.BAR_ISDEFAULT, meta.getIsDefault(), false);
		DomHelper.writeAttr(element, MetaConstants.TREEMENUBAR_MENUTYPE, meta.getMenuType(), 1);
	}
	
	@Override
	public void load(Document document, Element element, MetaTreeMenuBar meta, int runType) {
		super.load(document, element, meta, runType);
		meta.setType(TreeMenuBarType.parse(DomHelper.readAttr(element, MetaConstants.TREEMENUBAR_TYPE, TreeMenuBarType.STR_Tree)));
		meta.setSource(DomHelper.readAttr(element, MetaConstants.TREEMENUBAR_SOURCE, ""));
		meta.setTag(DomHelper.readAttr(element, MetaConstants.COMMON_TAG, ""));
		meta.setIsDefault(DomHelper.readAttr(element, MetaConstants.BAR_ISDEFAULT, false));
		meta.setMenuType(DomHelper.readAttr(element, MetaConstants.TREEMENUBAR_MENUTYPE, 1));
	}
}
