package com.bokesoft.yes.meta.persist.dom.form.component;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.common.util.TypeConvertor;
import com.bokesoft.yigo.meta.form.component.MetaFont;

public class MetaFontAction extends BaseDomAction<MetaFont> {

	@Override
	public void load(Document document, Element element, MetaFont meta, int runType) {
		meta.setName(DomHelper.readAttr(element, MetaConstants.FORMAT_FONTNAME, ""));
		meta.setSize(DomHelper.readAttr(element, MetaConstants.FORMAT_FONTSIZE, -1));
		meta.setBold(DomHelper.readAttr(element, MetaConstants.FORMAT_BOLD, false));
		meta.setItalic(DomHelper.readAttr(element, MetaConstants.FORMAT_ITALIC, false));
		meta.setUnderline(DomHelper.readAttr(element, MetaConstants.FORMAT_UNDERLINE, false));
		meta.setUnderlineColor(DomHelper.readAttr(element, MetaConstants.FORMAT_UNDERLINECOLOR, ""));
	}

	@Override
	public void save(Document document, Element element, MetaFont meta, int runType) {
		DomHelper.writeAttr(element, MetaConstants.FORMAT_FONTNAME, meta.getName(), "");
		DomHelper.writeAttr(element, MetaConstants.FORMAT_FONTSIZE, meta.getSize(), -1);
		DomHelper.writeAttr(element, MetaConstants.FORMAT_BOLD, meta.getBold(), false);
		DomHelper.writeAttr(element, MetaConstants.FORMAT_ITALIC, meta.getItalic(), false);
		DomHelper.writeAttr(element, MetaConstants.FORMAT_UNDERLINE, meta.isUnderline(), false);
		DomHelper.writeAttr(element, MetaConstants.FORMAT_UNDERLINECOLOR, meta.getUnderlineColor(), "");
	}

}