package com.bokesoft.yes.meta.persist.dom.form.component;

import org.apache.commons.lang3.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.def.DefSize;
import com.bokesoft.yigo.common.def.DirectionType;
import com.bokesoft.yigo.common.def.HAlignment;
import com.bokesoft.yigo.common.def.Position;
import com.bokesoft.yigo.common.def.VAlignment;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.form.component.MetaComponent;

/**
 * 所以控件的基础类对象在保存和载入时的相关动作
 *
 * @author 陈志盛
 * @since YES1.0
 */
public class MetaComponentAction<T extends MetaComponent> extends BaseDomAction<T> {
    protected BaseDomAction<AbstractMetaObject> propertiesAction = null;
    protected BaseDomAction<AbstractMetaObject> propertiesExtAction = null;

    @Override
    public void load(Document document, Element element, T meta, int runType) {
        meta.setKey(DomHelper.readAttr(element, MetaConstants.COMMON_KEY, ""));
        meta.setCaption(DomHelper.readAttr(element, MetaConstants.COMMON_CAPTION, ""));
        meta.setCaptionFull(DomHelper.readAttr(element, MetaConstants.COMMON_CAPTION_FULL, ""));
        meta.setCaptionEn(DomHelper.readAttr(element, MetaConstants.COMMON_CAPTION_EN, ""));
        meta.setCaptionEnFull(DomHelper.readAttr(element, MetaConstants.COMMON_CAPTION_EN_FULL, ""));
		meta.setFormulaCaption(DomHelper.readAttr(element, MetaConstants.COMMON_FORMULACAPTION, ""));
		meta.setCaptionDependency(DomHelper.readAttr(element, MetaConstants.COMMON_CAPTIONDEPENDENCY, ""));
        meta.setBuddyKey(DomHelper.readAttr(element, MetaConstants.COMPONENT_BUDDYKEY, ""));
        meta.setBindingCellKey(DomHelper.readAttr(element, MetaConstants.BINDINGCELLKEY, ""));
        meta.setX(DomHelper.readAttr(element, MetaConstants.COMPONENT_X, -1));
        meta.setY(DomHelper.readAttr(element, MetaConstants.COMPONENT_Y, -1));
        meta.setXSpan(DomHelper.readAttr(element, MetaConstants.COMPONENT_XSPAN, 1));
        meta.setYSpan(DomHelper.readAttr(element, MetaConstants.COMPONENT_YSPAN, 1));
        meta.setPosition(Position.parse(DomHelper.readAttr(element, MetaConstants.COMPONENT_POSITION, Position.STR_Static)));
        meta.setLeft(DomHelper.readAttr(element, MetaConstants.COMPONENT_LEFT, -1));
        meta.setTop(DomHelper.readAttr(element, MetaConstants.COMPONENT_TOP, -1));
        meta.setRight(DomHelper.readAttr(element, MetaConstants.COMPONENT_RIGHT, -1));
        meta.setBottom(DomHelper.readAttr(element, MetaConstants.COMPONENT_BOTTOM, -1));
        meta.setFloatType(DirectionType.parse(DomHelper.readAttr(element, MetaConstants.COMPONENT_FLOAT, "")));
        meta.setArea(DirectionType.parse(DomHelper.readAttr(element, MetaConstants.COMPONENT_AREA, (String)null)));
        meta.setTabOrder(DomHelper.readAttr(element, MetaConstants.TAB_ORDER, -1));
        String width = DomHelper.readAttr(element, MetaConstants.COMMON_WIDTH, "");
        if (width != null && !width.isEmpty()) {
            meta.setWidth(DefSize.parse(width));
        }
        String height = DomHelper.readAttr(element, MetaConstants.COMMON_HEIGHT, "");
        if (height != null && !height.isEmpty()) {
            meta.setHeight(DefSize.parse(height));
        }
        String minHeight = DomHelper.readAttr(element, MetaConstants.COMMON_MINHEIGHT, "");
        if ( minHeight != null && !minHeight.isEmpty() ) {
            meta.setMinHeight(DefSize.parse(minHeight));
        }

        meta.setPadding(DomHelper.readAttr(element, MetaConstants.COMPONENT_PADDING, ""));
        meta.setTopPadding(DomHelper.readAttr(element, MetaConstants.COMPONENT_TOPPADDING, ""));
        meta.setRightPadding(DomHelper.readAttr(element, MetaConstants.COMPONENT_RIGHTPADDING, ""));
        meta.setBottomPadding(DomHelper.readAttr(element, MetaConstants.COMPONENT_BOTTOMPADDING, ""));
        meta.setLeftPadding(DomHelper.readAttr(element, MetaConstants.COMPONENT_LEFTPADDING, ""));

        meta.setMargin(DomHelper.readAttr(element, MetaConstants.COMPONENT_MARGIN, ""));
        meta.setTopMargin(DomHelper.readAttr(element, MetaConstants.COMPONENT_TOPMARGIN, ""));
        meta.setRightMargin(DomHelper.readAttr(element, MetaConstants.COMPONENT_RIGHTMARGIN, ""));
        meta.setBottomMargin(DomHelper.readAttr(element, MetaConstants.COMPONENT_BOTTOMMARGIN, ""));
        meta.setLeftMargin(DomHelper.readAttr(element, MetaConstants.COMPONENT_LEFTMARGIN, ""));

        meta.setHAlign(HAlignment.parse(DomHelper.readAttr(element, MetaConstants.COMPONENT_HALIGN, HAlignment.STR_CENTER)));
        meta.setVAlign(VAlignment.parse(DomHelper.readAttr(element, MetaConstants.COMPONENT_VALIGN, VAlignment.STR_TOP)));
        String cssClass = DomHelper.readAttr(element, MetaConstants.COMPONENT_CLASS, "");
        if (StringUtils.isBlank(cssClass)) {
            cssClass = DomHelper.readAttr(element, MetaConstants.OPERATION_CSSCLASS, "");
        }
        meta.setCssClass(cssClass);

        meta.setBorderColor(DomHelper.readAttr(element, MetaConstants.COMPONENT_BORDERCOLOR, ""));
        meta.setBorderRadius(DomHelper.readAttr(element, MetaConstants.COMPONENT_BORDERRADIUS, ""));
        meta.setBorderWidth(DomHelper.readAttr(element, MetaConstants.COMPONENT_BORDERWIDTH, ""));
        meta.setBorderStyle(DomHelper.readAttr(element, MetaConstants.COMPONENT_BORDERSTYLE, ""));
        String weight = DomHelper.readAttr(element, MetaConstants.COMPONENT_WEIGHT, "");
        if (weight != null && !weight.isEmpty()) {
            meta.setWeight(Float.parseFloat(weight));
        }

        meta.setAsQuery(DomHelper.readAttr(element, MetaConstants.COMPONENT_ASQUERY, false));
        meta.setClearable(DomHelper.readAttr(element, MetaConstants.COMMON_CLEARABLE, true));
        meta.setCopyNew(DomHelper.readAttr(element, MetaConstants.COMPONENT_COPYNEW, true));

        meta.setEnable(DomHelper.readAttr(element, MetaConstants.COMMON_ENABLE, ""));
        meta.setEnableDependency(DomHelper.readAttr(element, MetaConstants.COMMON_ENABLE_DEPENDENCY, ""));

        meta.setVisible(DomHelper.readAttr(element, MetaConstants.COMMON_VISIBLE, ""));
        meta.setVisibleDependency(DomHelper.readAttr(element, MetaConstants.COMMON_VISIBLE_DEPENDENCY, ""));

        meta.setToolTip(DomHelper.readAttr(element, MetaConstants.COMPONENT_TOOLTIP, ""));
        meta.setFormulaTip(DomHelper.readAttr(element, MetaConstants.COMPONENT_FORMULATIP, ""));

        meta.setInitEnable(DomHelper.readBool(element, MetaConstants.COMMON_INITENABLE, null));
        meta.setInitVisible(DomHelper.readBool(element, MetaConstants.COMMON_INITVISIBLE, null));
        meta.setOnlyShow(DomHelper.readBool(element, MetaConstants.COMPONENT_ONLYSHOW, null));
        meta.setCompStyle(DomHelper.readAttr(element, MetaConstants.COMPONENT_COMPSTYLE, ""));
        meta.setOneTimeCompute(DomHelper.readBool(element, MetaConstants.COMPONENT_ONETIMECOMPUTE, null));
        if ( propertiesAction != null && meta.getProperties() != null ) {
            propertiesAction.load(document, element, meta.getProperties(), runType);
            meta.setParameterID(DomHelper.readAttr(element, "ParameterID", ""));
            meta.setSetParameter(DomHelper.readBool(element, "SetParameter", false));
            meta.setGetParameter(DomHelper.readBool(element, "GetParameter", false));
        }

    }

    @Override
    public void save(Document document, Element element, T meta, int runType) {
        DomHelper.writeAttr(element, MetaConstants.COMMON_KEY, meta.getKey(), "");
        DomHelper.writeAttr(element, MetaConstants.COMMON_CAPTION, meta.getCaption(), "");
        DomHelper.writeAttr(element, MetaConstants.COMMON_CAPTION_FULL, meta.getCaptionFull(), "");
        DomHelper.writeAttr(element, MetaConstants.COMMON_CAPTION_EN, meta.getCaptionEn(), "");
        DomHelper.writeAttr(element, MetaConstants.COMMON_CAPTION_EN_FULL, meta.getCaptionEnFull(), "");
		DomHelper.writeAttr(element, MetaConstants.COMMON_FORMULACAPTION, meta.getFormulaCaption(), "");
		DomHelper.writeAttr(element, MetaConstants.COMMON_CAPTIONDEPENDENCY, meta.getCaptionDependency(), "");
        DomHelper.writeAttr(element, MetaConstants.COMPONENT_BUDDYKEY, meta.getBuddyKey(), "");
        DomHelper.writeAttr(element, MetaConstants.BINDINGCELLKEY, meta.getBindingCellKey(), "");
        DomHelper.writeAttr(element, MetaConstants.COMMON_ENABLE, meta.getEnable(), "");
        DomHelper.writeAttr(element, MetaConstants.COMMON_VISIBLE, meta.getVisible(), "");
        DomHelper.writeAttr(element, MetaConstants.COMMON_ENABLE_DEPENDENCY, meta.getEnableDependency(), "");
        DomHelper.writeAttr(element, MetaConstants.COMMON_VISIBLE_DEPENDENCY, meta.getVisibleDependency(), "");
        DomHelper.writeAttr(element, MetaConstants.COMPONENT_X, meta.getX(), -1);
        DomHelper.writeAttr(element, MetaConstants.COMPONENT_Y, meta.getY(), -1);
        DomHelper.writeAttr(element, MetaConstants.COMPONENT_XSPAN, meta.getXSpan(), 1);
        DomHelper.writeAttr(element, MetaConstants.COMPONENT_YSPAN, meta.getYSpan(), 1);
        DomHelper.writeAttr(element, MetaConstants.COMPONENT_POSITION, Position.toString(meta.getPosition()), Position.STR_Static);
        DomHelper.writeAttr(element, MetaConstants.COMPONENT_LEFT, meta.getLeft(), -1);
        DomHelper.writeAttr(element, MetaConstants.COMPONENT_TOP, meta.getTop(), -1);
        DomHelper.writeAttr(element, MetaConstants.COMPONENT_RIGHT, meta.getRight(), -1);
        DomHelper.writeAttr(element, MetaConstants.COMPONENT_BOTTOM, meta.getBottom(), -1);
        DomHelper.writeAttr(element, MetaConstants.COMPONENT_FLOAT, DirectionType.toString(meta.getFloatType()), "");
        DomHelper.writeAttr(element, MetaConstants.COMPONENT_AREA, DirectionType.toString(meta.getArea()), "");
        DomHelper.writeAttr(element, MetaConstants.TAB_ORDER, meta.getTabOrder(), -1);

        DefSize width = meta.getWidth();
        if (width != null) {
            DomHelper.writeAttr(element, MetaConstants.COMMON_WIDTH, width.toString(), "");
        }else {
            DomHelper.writeAttr(element, MetaConstants.COMMON_WIDTH, (String)null, null);
        }

        DefSize height = meta.getHeight();
        if (height != null) {
            DomHelper.writeAttr(element, MetaConstants.COMMON_HEIGHT, height.toString(), "");
        }else {
            DomHelper.writeAttr(element, MetaConstants.COMMON_HEIGHT, (String)null, null);
        }

        DefSize minHeight = meta.getMinHeight();
        if ( minHeight != null ) {
            DomHelper.writeAttr(element, MetaConstants.COMMON_MINHEIGHT, minHeight.toString(), "");
        }else {
            DomHelper.writeAttr(element, MetaConstants.COMMON_MINHEIGHT, (String)null, null);
        }

        DomHelper.writeAttr(element, MetaConstants.COMPONENT_PADDING, meta.getPadding(), "");
        DomHelper.writeAttr(element, MetaConstants.COMPONENT_TOPPADDING, meta.getTopPadding(), "");
        DomHelper.writeAttr(element, MetaConstants.COMPONENT_RIGHTPADDING, meta.getRightPadding(), "");
        DomHelper.writeAttr(element, MetaConstants.COMPONENT_BOTTOMPADDING, meta.getBottomPadding(), "");
        DomHelper.writeAttr(element, MetaConstants.COMPONENT_LEFTPADDING, meta.getLeftPadding(), "");

        DomHelper.writeAttr(element, MetaConstants.COMPONENT_MARGIN, meta.getMargin(), "");
        DomHelper.writeAttr(element, MetaConstants.COMPONENT_TOPMARGIN, meta.getTopMargin(), "");
        DomHelper.writeAttr(element, MetaConstants.COMPONENT_RIGHTMARGIN, meta.getRightMargin(), "");
        DomHelper.writeAttr(element, MetaConstants.COMPONENT_BOTTOMMARGIN, meta.getBottomMargin(), "");
        DomHelper.writeAttr(element, MetaConstants.COMPONENT_LEFTMARGIN, meta.getLeftMargin(), "");

        DomHelper.writeAttr(element, MetaConstants.COMPONENT_HALIGN, HAlignment.toString(meta.getHAlign()), HAlignment.STR_CENTER);
        DomHelper.writeAttr(element, MetaConstants.COMPONENT_VALIGN, VAlignment.toString(meta.getVAlign()), VAlignment.STR_TOP);
        DomHelper.writeAttr(element, MetaConstants.COMPONENT_CLASS, meta.getCssClass(), "");

        DomHelper.writeAttr(element, MetaConstants.COMPONENT_TOOLTIP, meta.getToolTip(), "");
        DomHelper.writeAttr(element, MetaConstants.COMPONENT_FORMULATIP, meta.getFormulaTip(), "");
        DomHelper.writeAttr(element, MetaConstants.COMPONENT_BORDERCOLOR, meta.getBorderColor(), "");
        DomHelper.writeAttr(element, MetaConstants.COMPONENT_BORDERRADIUS, meta.getBorderRadius(), "");
        DomHelper.writeAttr(element, MetaConstants.COMPONENT_BORDERWIDTH, meta.getBorderWidth(), "");
        DomHelper.writeAttr(element, MetaConstants.COMPONENT_BORDERSTYLE, meta.getBorderStyle(), "");
        DomHelper.writeAttr(element, MetaConstants.COMPONENT_WEIGHT, String.valueOf(meta.getWeight()), "0.0");
        DomHelper.writeAttr(element, MetaConstants.COMPONENT_ASQUERY, meta.isAsQuery(), false);
        DomHelper.writeAttr(element, MetaConstants.COMMON_CLEARABLE, meta.isClearable(), true);
        DomHelper.writeAttr(element, MetaConstants.COMPONENT_COPYNEW, meta.isCopyNew(), true);

        DomHelper.writeAttr(element, MetaConstants.COMMON_INITVISIBLE, meta.getInitVisible(), null);
        DomHelper.writeAttr(element, MetaConstants.COMMON_INITENABLE, meta.getInitEnable(), null);
        DomHelper.writeAttr(element, MetaConstants.COMPONENT_ONLYSHOW, meta.isOnlyShow(), null);
        DomHelper.writeAttr(element, MetaConstants.COMPONENT_COMPSTYLE, meta.getCompStyle(), "");
        DomHelper.writeAttr(element, MetaConstants.COMPONENT_ONETIMECOMPUTE, meta.getOneTimeCompute(), null);
        if ( propertiesAction != null && meta.getProperties() != null ) {
            propertiesAction.save(document, element, meta.getProperties(), runType);
            DomHelper.writeAttr(element,"ParameterID", meta.getParameterID(), "");
            DomHelper.writeAttr(element, "GetParameter", meta.isGetParameter(), false);
            DomHelper.writeAttr(element, "SetParameter", meta.isSetParameter(), false);
        }

    }
}