package com.bokesoft.yes.meta.persist.dom.form;

import com.bokesoft.yes.meta.persist.dom.common.MetaBaseScriptAction;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.form.MetaShortCut;
import com.bokesoft.yigo.meta.form.MetaUICheckRule;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class MetaShortCutAction extends MetaBaseScriptAction<MetaShortCut> {

	@Override
	public void load(Document document, Element element, MetaShortCut meta, int runType) {
		super.load(document, element, meta, runType);
		
		meta.setKey(DomHelper.readAttr(element, MetaConstants.COMMON_KEY, ""));
		meta.setShortCut(DomHelper.readAttr(element, MetaConstants.Event_CellShortCut, ""));
	}

	@Override
	public void save(Document document, Element element, MetaShortCut meta, int runType) {
		super.save(document, element, meta, runType);
		
		DomHelper.writeAttr(element, MetaConstants.COMMON_KEY, meta.getKey(), "");
		DomHelper.writeAttr(element, MetaConstants.Event_CellShortCut, meta.getShortCut(), "");
	}

}
