package com.bokesoft.yes.meta.persist.dom.form;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.common.MetaBaseScriptAction;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.form.MetaNavigationBarRightButton;

public class MetaNavigationBarRightButtonAction extends MetaBaseScriptAction<MetaNavigationBarRightButton> {
	@Override
	public void load(Document document, Element element, MetaNavigationBarRightButton meta, int runType) {
		super.load(document, element, meta, runType);
		meta.setIcon(DomHelper.readAttr(element, MetaConstants.COMMON_ICON, ""));
	}

	@Override
	public void save(Document document, Element element, MetaNavigationBarRightButton meta, int runType) {
		super.save(document, element, meta, runType);
		DomHelper.writeAttr(element, MetaConstants.COMMON_ICON, meta.getIcon(), "");
	}
}
