package com.bokesoft.yes.meta.persist.dom.entry;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.entry.MetaEntry;

public class MetaEntryAction extends BaseDomAction<MetaEntry> {

	@Override
	public void load(Document document, Element element,
			MetaEntry meta, int runType) {
		meta.setKey(DomHelper.readAttr(element, MetaConstants.COMMON_KEY, ""));
		meta.setCaption(DomHelper.readAttr(element, MetaConstants.COMMON_CAPTION, ""));
		meta.setCaptionEn(DomHelper.readAttr(element, MetaConstants.COMMON_CAPTION_EN, ""));
		meta.setOpen(DomHelper.readAttr(element, MetaConstants.ENTRY_OPEN, false));
		meta.setIcon(DomHelper.readAttr(element, MetaConstants.COMMON_ICON, ""));
		meta.setIconCode(DomHelper.readAttr(element, MetaConstants.COMMON_ICON_CODE, ""));
		meta.setVisible(DomHelper.readAttr(element, MetaConstants.COMMON_VISIBLE, ""));
	}

	@Override
	public void save(Document document, Element element,
			MetaEntry meta, int runType) {
		DomHelper.writeAttr(element, MetaConstants.COMMON_KEY, meta.getKey(), "");
		DomHelper.writeAttr(element, MetaConstants.COMMON_CAPTION, meta.getCaption(), "");
		DomHelper.writeAttr(element, MetaConstants.COMMON_CAPTION_EN, meta.getCaptionEn(), "");
		DomHelper.writeAttr(element, MetaConstants.ENTRY_OPEN, meta.isOpen(),false);
		DomHelper.writeAttr(element, MetaConstants.COMMON_ICON, meta.getIcon(), "");
		DomHelper.writeAttr(element, MetaConstants.COMMON_ICON_CODE, meta.getIconCode(), "");
		DomHelper.writeAttr(element, MetaConstants.COMMON_VISIBLE, meta.getVisible(), "");
	}

}
