package com.bokesoft.yes.meta.persist.dom.dataobject;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.common.MetaBaseScriptAction;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.dataobject.MetaStatusTrigger;

public class MetaStatusTriggerAction extends MetaBaseScriptAction<MetaStatusTrigger> {
	@Override
	public void load(Document document, Element element,
			MetaStatusTrigger meta, int runType) {
		super.load(document, element, meta, runType);
		meta.setStatusKey(DomHelper.readAttr(element, MetaConstants.STATUSTRIGGER_STATUSKEY, ""));
	}

	@Override
	public void save(Document document, Element element,
			MetaStatusTrigger meta, int runType) {
		super.save(document, element, meta, runType);
		DomHelper.writeAttr(element, MetaConstants.STATUSTRIGGER_STATUSKEY, meta.getStatusKey(), "");
	}
	
}
