package com.bokesoft.yes.meta.persist.dom.dataobject;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.dataobject.MetaMigrationValueCompare;

public class MetaMigrationValueCompareAction extends BaseDomAction<MetaMigrationValueCompare> {

	@Override
	public void load(Document document, Element element, MetaMigrationValueCompare meta, int runType) {
		meta.setColumnKey(DomHelper.readAttr(element, MetaConstants.DATABINDING_COLUMNKEY, ""));
		meta.setTableKey(DomHelper.readAttr(element, MetaConstants.DATABINDING_TABLEKEY, ""));
		meta.setValue(DomHelper.readAttr(element, MetaConstants.COMMON_VALUE, ""));
		meta.setDescription(DomHelper.readAttr(element, MetaConstants.COMMON_DESCRIPTION, ""));
		meta.setErrorInfo(DomHelper.readAttr(element, MetaConstants.CHECKRULE_ERRORINFO, ""));
	}

	@Override
	public void save(Document document, Element element, MetaMigrationValueCompare meta, int runType) {
		DomHelper.writeAttr(element, MetaConstants.DATABINDING_COLUMNKEY, meta.getColumnKey(), "");
		DomHelper.writeAttr(element, MetaConstants.DATABINDING_TABLEKEY, meta.getTableKey(), "");
		DomHelper.writeAttr(element, MetaConstants.COMMON_VALUE, meta.getValue(), "");
		DomHelper.writeAttr(element, MetaConstants.COMMON_DESCRIPTION, meta.getDescription(), "");
		DomHelper.writeAttr(element, MetaConstants.CHECKRULE_ERRORINFO, meta.getErrorInfo(), "");
	}

}
