package com.bokesoft.yes.meta.persist.dom.datamap.split;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yes.meta.persist.dom.datamap.MetaMapConstants;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.datamap.split.MetaSplit;
import com.bokesoft.yigo.meta.datamap.split.SplitType;

public class MetaSplitAction extends BaseDomAction<MetaSplit> {

	@Override
	public void load(Document document, Element element, MetaSplit meta, int runType) {
		meta.setType(SplitType.parse(DomHelper.readAttr(element, MetaMapConstants.SPLIT_TYPE, "")));
	}

	@Override
	public void save(Document document, Element element, MetaSplit meta, int runType) {
		DomHelper.writeAttr(element, MetaMapConstants.SPLIT_TYPE, SplitType.toString(meta.getType()), "");
	}

}
