package com.bokesoft.yes.meta.persist.dom.datamap;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.datamap.source.FieldType;
import com.bokesoft.yigo.meta.datamap.source.MetaSourceField;

public class MetaSourceFieldAction extends BaseDomAction<MetaSourceField> {

	@Override
	public void load(Document document, Element element, MetaSourceField meta, int runType) {
		meta.setKey(DomHelper.readAttr(element, MetaMapConstants.FIELD_KEY, ""));
		meta.setType(FieldType.parseType(DomHelper.readAttr(element, MetaMapConstants.FIELD_TYPE, FieldType.STR_FIELD)));
		meta.setOpSign(FieldType.parseOpSign(DomHelper.readAttr(element, MetaMapConstants.FIELD_OP_SIGN, FieldType.STR_OP_ASSIGN)));
		meta.setEdgeType(FieldType.parseEdgeType(DomHelper.readAttr(element, MetaMapConstants.FIELD_EDGE_TYPE, FieldType.STR_EDGE_NORMAL)));
		meta.setCondition(DomHelper.readAttr(element, MetaMapConstants.FIELD_CONDITION, ""));
		meta.setEditable(DomHelper.readAttr(element, MetaMapConstants.FIELD_EDITABLE, true));
		meta.setTargetTableKey(DomHelper.readAttr(element, MetaMapConstants.FIELD_TARGET_TABLE_KEY, ""));
		meta.setTargetFieldKey(DomHelper.readAttr(element, MetaMapConstants.FIELD_TARGET_FIELD_KEY, ""));
		meta.setRefFieldKey(DomHelper.readAttr(element, MetaMapConstants.FIELD_REF_FIELD_KEY, ""));
		meta.setDefinition(DomHelper.readAttr(element, MetaMapConstants.FIELD_DEFINITION, ""));
		meta.setNegtive(DomHelper.readAttr(element, MetaMapConstants.FIELD_NEGTIVE, false));
		meta.setTargetDirectionFieldKey(DomHelper.readAttr(element, MetaMapConstants.FIELD_TARGETDIRECTIONFIELDKEY,  ""));
	}

	@Override
	public void save(Document document, Element element, MetaSourceField meta, int runType) {
		DomHelper.writeAttr(element, MetaMapConstants.FIELD_KEY, meta.getKey(), "");
		DomHelper.writeAttr(element, MetaMapConstants.FIELD_TYPE, FieldType.formatTypeString(meta.getType()), FieldType.STR_FIELD);
		DomHelper.writeAttr(element, MetaMapConstants.FIELD_OP_SIGN, FieldType.formatOpSignString(meta.getOpSign()), FieldType.STR_OP_ASSIGN);
		DomHelper.writeAttr(element, MetaMapConstants.FIELD_EDGE_TYPE, FieldType.formatEdgeTypeString(meta.getEdgeType()), FieldType.STR_EDGE_NORMAL);
		DomHelper.writeAttr(element, MetaMapConstants.FIELD_CONDITION, meta.getCondition(), "");
		DomHelper.writeAttr(element, MetaMapConstants.FIELD_EDITABLE, meta.isEditable(), true);
		DomHelper.writeAttr(element, MetaMapConstants.FIELD_TARGET_TABLE_KEY, meta.getTargetTableKey(), "");
		DomHelper.writeAttr(element, MetaMapConstants.FIELD_TARGET_FIELD_KEY, meta.getTargetFieldKey(), "");
		DomHelper.writeAttr(element, MetaMapConstants.FIELD_REF_FIELD_KEY, meta.getRefFieldKey(), "");
		DomHelper.writeAttr(element, MetaMapConstants.FIELD_DEFINITION, meta.getDBDefinition(), "");
		DomHelper.writeAttr(element, MetaMapConstants.FIELD_NEGTIVE, meta.isNegtive(), false);
		DomHelper.writeAttr(element, MetaMapConstants.FIELD_TARGETDIRECTIONFIELDKEY, meta.getTargetDirectionFieldKey(), "");
	}

}
