package com.bokesoft.yes.meta.persist.dom.datamap;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.datamap.relatedatamap.MetaRelateDataMap;

public class MetaRelateDataMapAction extends BaseDomAction<MetaRelateDataMap> {

	@Override
	public void load(Document document, Element element, MetaRelateDataMap meta, int runType) {
		meta.setKey(DomHelper.readAttr(element, MetaConstants.COMMON_KEY, ""));
		meta.setNegative(DomHelper.readAttr(element, MetaMapConstants.RELATE_NEGATIVE, false));
	}

	@Override
	public void save(Document document, Element element, MetaRelateDataMap meta, int runType) {
		DomHelper.writeAttr(element, MetaConstants.COMMON_KEY, meta.getKey(), "");
		DomHelper.writeAttr(element, MetaMapConstants.RELATE_NEGATIVE, meta.isNegative(), false);
	}

}
