package com.bokesoft.yes.meta.persist.dom.commondef;

import com.bokesoft.yes.meta.persist.dom.MetaActionMap;
import com.bokesoft.yes.meta.persist.dom.common.MetaBaseScriptAction;
import com.bokesoft.yes.meta.persist.dom.common.MetaComponentSettingAction;
import com.bokesoft.yes.meta.persist.dom.common.MetaFieldLabelAction;
import com.bokesoft.yes.meta.persist.dom.common.MetaFieldLabelCollectionAction;
import com.bokesoft.yes.meta.persist.dom.common.MetaMacroAction;
import com.bokesoft.yes.meta.persist.dom.common.MetaMacroCollectionAction;
import com.bokesoft.yes.meta.persist.dom.common.MetaQueryAction;
import com.bokesoft.yes.meta.persist.dom.common.MetaQueryCollectionAction;
import com.bokesoft.yes.meta.persist.dom.common.MetaStatementAction;
import com.bokesoft.yes.meta.persist.dom.commondef.resource.MetaIconFontItemAction;
import com.bokesoft.yes.meta.persist.dom.commondef.resource.MetaIconFontSourceAction;
import com.bokesoft.yes.meta.persist.dom.commondef.resource.MetaIconFontSourceCollectionAction;
import com.bokesoft.yes.meta.persist.dom.commondef.resource.MetaIconSourceAction;
import com.bokesoft.yes.meta.persist.dom.commondef.resource.MetaIconSourceCollectionAction;
import com.bokesoft.yes.meta.persist.dom.dataobject.MetaCheckRuleAction;
import com.bokesoft.yes.meta.persist.dom.dataobject.MetaCheckRuleCollectionAction;
import com.bokesoft.yes.meta.persist.dom.dataobject.MetaStatementCollectionAction;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.meta.bpm.BPMConstants;
import com.bokesoft.yigo.meta.common.MetaComponentSetting;
import com.bokesoft.yigo.meta.common.MetaFieldLabel;
import com.bokesoft.yigo.meta.common.MetaFieldLabelCollection;
import com.bokesoft.yigo.meta.common.MetaMacro;
import com.bokesoft.yigo.meta.common.MetaMacroCollection;
import com.bokesoft.yigo.meta.common.MetaQuery;
import com.bokesoft.yigo.meta.common.MetaQueryCollection;
import com.bokesoft.yigo.meta.common.MetaScript;
import com.bokesoft.yigo.meta.common.MetaScriptCollection;
import com.bokesoft.yigo.meta.common.MetaStatement;
import com.bokesoft.yigo.meta.common.MetaStatementCollection;
import com.bokesoft.yigo.meta.commondef.MetaCommonDef;
import com.bokesoft.yigo.meta.commondef.MetaOperation;
import com.bokesoft.yigo.meta.commondef.MetaOperationCollection;
import com.bokesoft.yigo.meta.commondef.MetaSearchBoxProvider;
import com.bokesoft.yigo.meta.commondef.MetaSearchBoxProviderCollection;
import com.bokesoft.yigo.meta.commondef.MetaStatus;
import com.bokesoft.yigo.meta.commondef.MetaStatusCollection;
import com.bokesoft.yigo.meta.commondef.extend.MetaCommonDefCollection;
import com.bokesoft.yigo.meta.commondef.resource.MetaIconFontItem;
import com.bokesoft.yigo.meta.commondef.resource.MetaIconFontSource;
import com.bokesoft.yigo.meta.commondef.resource.MetaIconFontSourceCollection;
import com.bokesoft.yigo.meta.commondef.resource.MetaIconSource;
import com.bokesoft.yigo.meta.commondef.resource.MetaIconSourceCollection;
import com.bokesoft.yigo.meta.dataobject.MetaCheckRule;
import com.bokesoft.yigo.meta.dataobject.MetaCheckRuleCollection;

public class MetaCommonDefCollectionActionMap extends MetaActionMap {
	private MetaCommonDefCollectionActionMap() {
		super();
	}

	@Override
	protected Object[][] getActionLookupTable() {
		return new Object[][]{
				{ MetaCommonDef.TAG_NAME, new MetaCommonDefAction() },
				{ MetaOperationCollection.TAG_NAME, new MetaOperationCollectionAction() },
				{ MetaOperation.TAG_NAME, new MetaOperationAction() },
				{ MetaStatusCollection.TAG_NAME, new MetaStatusCollectionAction() },
				{ MetaStatus.TAG_NAME, new MetaStatusAction() },
				{ MetaComponentSetting.TAG_NAME, new MetaComponentSettingAction() },
				{ MetaMacroCollection.TAG_NAME, new MetaMacroCollectionAction() },
				{ MetaMacro.TAG_NAME, new MetaMacroAction()},
				{ MetaSearchBoxProviderCollection.TAG_NAME, new MetaSearchBoxProviderCollectionAction() },
				{ MetaSearchBoxProvider.TAG_NAME, new MetaSearchBoxProviderAction() },

				//查询语句
				{ MetaQueryCollection.TAG_NAME, new MetaQueryCollectionAction() },
				{ MetaQuery.TAG_NAME, new MetaQueryAction() },
				{ MetaStatement.TAG_NAME, new MetaStatementAction() },
				{ MetaStatementCollection.TAG_NAME, new MetaStatementCollectionAction() },

				{ BPMConstants.NODE_ACTION,  new MetaBaseScriptAction<>()} ,
				{ MetaConstants.Event_ExceptionHandler, new MetaBaseScriptAction<>()},
				{ MetaCheckRuleCollection.TAG_NAME, new MetaCheckRuleCollectionAction() },
				{ MetaCheckRule.TAG_NAME, new MetaCheckRuleAction() },

				// iconSource
				{ MetaIconFontSourceCollection.TAG_NAME, new MetaIconFontSourceCollectionAction() },
				{ MetaIconFontSource.TAG_NAME, new MetaIconFontSourceAction() },
				{ MetaIconSourceCollection.TAG_NAME, new MetaIconSourceCollectionAction() },
				{ MetaIconSource.TAG_NAME, new MetaIconSourceAction() },
				{ MetaIconFontItem.TAG_NAME, new MetaIconFontItemAction() },

				{ MetaFieldLabel.TAG_NAME, new MetaFieldLabelAction() },
				{ MetaFieldLabelCollection.TAG_NAME, new MetaFieldLabelCollectionAction() },
			{ MetaCommonDefCollection.TAG_NAME, new MetaCommonDefCollectionAction() }
		};
	}

	@Override
	protected Object[][] getHostActionLookupTable() {
		return null;
	}

	private static MetaCommonDefCollectionActionMap instance = null;
	public static MetaCommonDefCollectionActionMap getInstance() {
		if ( instance == null ) {
			instance = new MetaCommonDefCollectionActionMap();
		}
		return instance;
	}

}
