package com.bokesoft.yes.meta.persist.dom.common;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.common.MetaServiceRights;

public class MetaServiceRightsAction extends BaseDomAction<MetaServiceRights> {

	@Override
	public void load(Document document, Element element, MetaServiceRights meta, int runType) {
		meta.setKey(DomHelper.readAttr(element, MetaConstants.SERVICERIGHTS_KEY, ""));
		meta.setCaption(DomHelper.readAttr(element, MetaConstants.SERVICERIGHTS_CAPTION, ""));
		meta.setRefOperation(DomHelper.readAttr(element, MetaConstants.SERVICERIGHTS_REFOPERATION, ""));

	}

	@Override
	public void save(Document document, Element element, MetaServiceRights meta, int runType) {
		DomHelper.writeAttr(element, MetaConstants.SERVICERIGHTS_KEY, meta.getKey(), "");
		DomHelper.writeAttr(element, MetaConstants.SERVICERIGHTS_CAPTION, meta.getCaption(), "");
		DomHelper.writeAttr(element, MetaConstants.SERVICERIGHTS_REFOPERATION, meta.getRefOperation(), "");
	}

}
