package com.bokesoft.yes.meta.persist.dom.common;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.common.MetaCustomConditionPara;

public class MetaCustomConditionParaAction extends BaseDomAction<MetaCustomConditionPara> {

	@Override
	public void load(Document document, Element element, MetaCustomConditionPara meta, int runType) {
		meta.setKey(DomHelper.readAttr(element, MetaConstants.COMMON_KEY, ""));
		meta.setFormula(DomHelper.readAttr(element, MetaConstants.CUSTOM_CONDITION_FORMULA, ""));
	}

	@Override
	public void save(Document document, Element element, MetaCustomConditionPara meta, int runType) {
		DomHelper.writeAttr(element, MetaConstants.COMMON_KEY, meta.getKey(), "");
		DomHelper.writeAttr(element, MetaConstants.CUSTOM_CONDITION_FORMULA, meta.getFormula(), "");
	}

}
