package com.bokesoft.yes.meta.persist.dom.charging;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.charging.MetaChargingTargetField;

public class MetaChargingTargetFieldAction extends BaseDomAction<MetaChargingTargetField> {

	@Override
	public void load(Document document, Element element, MetaChargingTargetField meta, int runType) {
		meta.setSrcType(MetaChargingTargetField.parseSrcType(DomHelper.readAttr(element, MetaConstants.CHARGING_TARGET_SRC_TYPE, MetaChargingTargetField.STR_SRC_TYPE_FIELD)));
		meta.setSrcFieldKey(DomHelper.readAttr(element, MetaConstants.CHARGING_SRC_FIELD_KEY, ""));
		meta.setTgtFieldKey(DomHelper.readAttr(element, MetaConstants.CHARGING_TGT_FIELD_KEY, ""));
		meta.setIsPK(DomHelper.readAttr(element, MetaConstants.CHARGING_FIELD_IS_PK, false));
		meta.setAssignType(MetaChargingTargetField.parseAssignType(DomHelper.readAttr(element, MetaConstants.CHARGING_TARGET_ASSIGN_TYPE, MetaChargingTargetField.STR_ASSIGN_TYPE_OVERWRITE)));
	}

	@Override
	public void save(Document document, Element element, MetaChargingTargetField meta, int runType) {
		DomHelper.writeAttr(element, MetaConstants.CHARGING_TARGET_SRC_TYPE, MetaChargingTargetField.toSrcTypeString(meta.getSrcType()), MetaChargingTargetField.STR_SRC_TYPE_FIELD);
		DomHelper.writeAttr(element, MetaConstants.CHARGING_SRC_FIELD_KEY, meta.getSrcFieldKey(), "");
		DomHelper.writeAttr(element, MetaConstants.CHARGING_TGT_FIELD_KEY, meta.getTgtFieldKey(), "");
		DomHelper.writeAttr(element, MetaConstants.CHARGING_FIELD_IS_PK, meta.isPK(), false);
		DomHelper.writeAttr(element, MetaConstants.CHARGING_TARGET_ASSIGN_TYPE, MetaChargingTargetField.toAssignTypeString(meta.getAssignType()), MetaChargingTargetField.STR_ASSIGN_TYPE_OVERWRITE);
	}

}
