package com.bokesoft.yes.meta.persist.dom.charging;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.charging.MetaChargingObject;

public class MetaChargingObjectAction extends BaseDomAction<MetaChargingObject> {

	@Override
	public void load(Document document, Element element, MetaChargingObject meta, int runType) {
		meta.setKey(DomHelper.readAttr(element, MetaConstants.COMMON_KEY, ""));
		meta.setCaption(DomHelper.readAttr(element, MetaConstants.COMMON_CAPTION, ""));
		meta.setDescription(DomHelper.readAttr(element, MetaConstants.COMMON_DESCRIPTION, ""));
		meta.setObjectKey(DomHelper.readAttr(element, MetaConstants.CHARGING_OBJECT_KEY, ""));
		meta.setTableKey(DomHelper.readAttr(element, MetaConstants.CHARGING_TABLE_KEY, ""));
	}

	@Override
	public void save(Document document, Element element, MetaChargingObject meta, int runType) {
		DomHelper.writeAttr(element, MetaConstants.COMMON_KEY, meta.getKey(), "");
		DomHelper.writeAttr(element, MetaConstants.COMMON_CAPTION, meta.getCaption(), "");
		DomHelper.writeAttr(element, MetaConstants.COMMON_DESCRIPTION, meta.getDescription(), "");
		DomHelper.writeAttr(element, MetaConstants.CHARGING_OBJECT_KEY, meta.getObjectKey(), "");
		DomHelper.writeAttr(element, MetaConstants.CHARGING_TABLE_KEY, meta.getTableKey(), "");
	}

}
