package com.bokesoft.yes.meta.persist.dom.bpm.action.monitor;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yigo.common.def.MonitorEventType;
import com.bokesoft.yigo.common.def.MonitorScopeType;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.bpm.BPMConstants;
import com.bokesoft.yigo.meta.bpm.process.monitor.MetaMonitor;

public class MetaMonitorAction extends BaseDomAction<MetaMonitor> {

	@Override
	public void load(Document document, Element element, MetaMonitor meta, int runType) {
		meta.setType(MonitorEventType.parse(DomHelper.readAttr(element, BPMConstants.MONITOR_TYPE, "")));
		meta.setScope(MonitorScopeType.parse(DomHelper.readAttr(element, BPMConstants.MONITOR_SCOPE, MonitorScopeType.STR_GLOBAL)));
		meta.setLoggers(DomHelper.readAttr(element, BPMConstants.MONITOR_LOGGERS, ""));
		
	}

	@Override
	public void save(Document document, Element element, MetaMonitor meta, int runType) {
		DomHelper.writeAttr(element, BPMConstants.MONITOR_TYPE,MonitorEventType.toString( meta.getType()),"");
		DomHelper.writeAttr(element, BPMConstants.MONITOR_SCOPE, MonitorScopeType.toString(meta.getScope()),MonitorScopeType.STR_GLOBAL);
		DomHelper.writeAttr(element, BPMConstants.MONITOR_LOGGERS, meta.getLoggers(),"");
		
	}

}
