package com.bokesoft.yes.meta.persist.dom.bpm.action.data;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.bpm.BPMConstants;
import com.bokesoft.yigo.meta.bpm.process.data.MetaDataItemCollection;

public class MetaDataItemCollectionAction extends BaseDomAction<MetaDataItemCollection> {

	@Override
	public void load(Document document, Element element, MetaDataItemCollection meta, int runType) {
		meta.setCache(DomHelper.readAttr(element, BPMConstants.DATA_ITEM_CACHE, false));
	}

	@Override
	public void save(Document document, Element element, MetaDataItemCollection meta, int runType) {
		DomHelper.writeAttr(element, BPMConstants.DATA_ITEM_CACHE, meta.isCache(), false);
	}

}
