package com.bokesoft.yes.meta.persist.dom.bpm.action.collection.item;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yes.meta.persist.dom.form.MetaConstants;
import com.bokesoft.yigo.common.def.DataType;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.bpm.process.attribute.parameter.MetaStaticParameter;

public class MetaStaticParameterAction extends BaseDomAction<MetaStaticParameter> {

	@Override
	public void load(Document document, Element element, MetaStaticParameter meta, int runType) {
		meta.setFormula(DomHelper.readAttr(element, MetaConstants.QUERY_PARA_FORMULA, ""));
		meta.setDataType(DataType.parse(DomHelper.readAttr(element, MetaConstants.COLUMN_DATATYPE, "")));
		meta.setFieldKey(DomHelper.readAttr(element, MetaConstants.DICT_FILTERVALUE_FIELDKEY, ""));
	}

	@Override
	public void save(Document document, Element element, MetaStaticParameter meta, int runType) {
		DomHelper.writeAttr(element, MetaConstants.QUERY_PARA_FORMULA, meta.getFormula(), "");
		DomHelper.writeAttr(element, MetaConstants.COLUMN_DATATYPE, DataType.toString(meta.getDataType()), "");
		DomHelper.writeAttr(element, MetaConstants.DICT_FILTERVALUE_FIELDKEY, DataType.toString(meta.getDataType()), "");
	}

}
