package com.bokesoft.yes.meta.persist.dom.bpm.action.collection.item;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.bokesoft.yes.meta.persist.dom.BaseDomAction;
import com.bokesoft.yigo.common.dom.DomHelper;
import com.bokesoft.yigo.meta.bpm.BPMConstants;
import com.bokesoft.yigo.meta.bpm.migration.MetaDMField;
import com.bokesoft.yigo.meta.datamap.source.FieldType;

public class MetaDMFieldAction extends BaseDomAction<MetaDMField> {

	@Override
	public void load(Document doc, Element node, MetaDMField meta, int runType) {
		meta.setKey(DomHelper.readAttr(node, BPMConstants.COMMON_KEY, ""));
		meta.setSourceFieldKey(DomHelper.readAttr(node, BPMConstants.DATA_MIGRATION_SOURCE, ""));
		meta.setType(FieldType.parseType(DomHelper.readAttr(node, BPMConstants.DATA_MIGRATION_TYPE, FieldType.STR_FIELD)));
		meta.setConstValue(DomHelper.readAttr(node, BPMConstants.DATA_MIGRATION_CONSTVALUE, ""));
	}

	@Override
	public void save(Document doc, Element node, MetaDMField meta, int runType) {
		DomHelper.writeAttr(node, BPMConstants.COMMON_KEY, meta.getKey(), "");
		DomHelper.writeAttr(node, BPMConstants.DATA_MIGRATION_SOURCE, meta.getSourceFieldKey(), "");
		DomHelper.writeAttr(node, BPMConstants.DATA_MIGRATION_TYPE, FieldType.formatTypeString(meta.getType()), FieldType.STR_FIELD);
		DomHelper.writeAttr(node, BPMConstants.DATA_MIGRATION_CONSTVALUE, meta.getConstValue(), "");
	}

}
