/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yigo.meta.form.component.view.layout;

import com.bokesoft.yes.common.util.Callback;
import com.bokesoft.yes.meta.i18n.StringTable;
import com.bokesoft.yigo.common.util.SimpleStringFormat;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.KeyPairMetaObject;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.form.component.panel.gridpanel.MetaColumnDefCollection;
import com.bokesoft.yigo.meta.form.component.panel.gridpanel.MetaRowDefCollection;
import com.bokesoft.yigo.meta.form.component.view.layout.MetaComponentLayout;
import com.bokesoft.yigo.meta.form.component.view.layout.MetaLayoutSpan;
import java.util.LinkedList;

public class MetaGridLayout
extends MetaComponentLayout<MetaLayoutSpan> {
    private MetaRowDefCollection rowDefCollection = null;
    private MetaColumnDefCollection columnDefCollection = null;
    public static final String TAG_NAME = "GridLayout";

    @Override
    public int getLayoutType() {
        return 4;
    }

    @Override
    public String getTagName() {
        return TAG_NAME;
    }

    @Override
    public void getChildMetaObjects(LinkedList<Object> list) {
        super.getChildMetaObjects(list);
        this.addAll(list, new Object[]{this.rowDefCollection, this.columnDefCollection});
    }

    @Override
    public AbstractMetaObject clone() {
        MetaGridLayout newObject = (MetaGridLayout)super.clone();
        newObject.setRowDefCollection(this.rowDefCollection == null ? null : (MetaRowDefCollection)this.rowDefCollection.clone());
        newObject.setColumnDefCollection(this.columnDefCollection == null ? null : (MetaColumnDefCollection)this.columnDefCollection.clone());
        return newObject;
    }

    @Override
    public AbstractMetaObject newInstance() {
        return new MetaGridLayout();
    }

    public void setRowDefCollection(MetaRowDefCollection rowDefCollection) {
        this.rowDefCollection = rowDefCollection;
    }

    public MetaRowDefCollection getRowDefCollection() {
        return this.rowDefCollection;
    }

    public void setColumnDefCollection(MetaColumnDefCollection columnDefCollection) {
        this.columnDefCollection = columnDefCollection;
    }

    public MetaColumnDefCollection getColumnDefCollection() {
        return this.columnDefCollection;
    }

    @Override
    public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag, int runType) throws MetaException {
        AbstractMetaObject resultMetaObject = null;
        if ("LayoutSpan".equals(tagName)) {
            MetaLayoutSpan item = new MetaLayoutSpan();
            item.preProcessMetaObject(env, doc, node, flag, runType);
            this.add((KeyPairMetaObject)item);
            resultMetaObject = item;
        } else if ("RowDefCollection".equals(tagName)) {
            resultMetaObject = this.rowDefCollection = new MetaRowDefCollection();
        } else if ("ColumnDefCollection".equals(tagName)) {
            this.columnDefCollection = new MetaColumnDefCollection();
            resultMetaObject = this.columnDefCollection;
        }
        if (resultMetaObject == null) {
            resultMetaObject = super.createChildMetaObject(env, doc, node, tagName, flag, runType);
        }
        return resultMetaObject;
    }

    @Override
    public void doPostProcess(int flag, Callback<AbstractMetaObject, Boolean> callback) throws MetaException {
        super.doPostProcess(flag, callback);
        for (MetaLayoutSpan span : this) {
            if (span.getY() + span.getYSpan() > this.rowDefCollection.size()) {
                throw new MetaException(121, SimpleStringFormat.format((String)StringTable.getString(null, "", "RowDefinitionOutRange"), (Object[])new Object[]{this.getKey(), span.getKey()}));
            }
            if (span.getX() + span.getXSpan() <= this.columnDefCollection.size()) continue;
            throw new MetaException(122, SimpleStringFormat.format((String)StringTable.getString(null, "", "ColumnDefinitionOutRange"), (Object[])new Object[]{this.getKey(), span.getKey()}));
        }
    }
}

