/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yigo.meta.form.component.grid;

import com.bokesoft.yes.common.log.LogSvr;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.form.component.grid.IMetaGridColumnObject;
import com.bokesoft.yigo.meta.form.component.grid.MetaGridCell;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;

public class MetaGridColumnGroup
extends AbstractMetaObject
implements IMetaGridColumnObject {
    private ArrayList<IMetaGridColumnObject> objectArray = null;
    private MetaGridColumnGroup parentGroup = null;
    private int leftColumn = -1;
    private int rightColumn = -1;
    private int expandRowIndex = -1;
    private int expandColumnIndex = -1;
    private MetaGridCell expandCell = null;
    public static final String TAG_NAME = "ColumnGroup";

    public MetaGridColumnGroup(MetaGridColumnGroup parentGroup) {
        this.parentGroup = parentGroup;
        this.objectArray = new ArrayList();
    }

    @Override
    public void getChildMetaObjects(LinkedList<Object> list) {
    }

    @Override
    public String getTagName() {
        return TAG_NAME;
    }

    @Override
    public AbstractMetaObject createChildMetaObject(IMetaEnv env, Object doc, Object node, String tagName, Object flag, int runType) throws MetaException {
        return null;
    }

    public void addObject(IMetaGridColumnObject column) {
        this.objectArray.add(column);
    }

    public int getObjectCount() {
        return this.objectArray.size();
    }

    public IMetaGridColumnObject getObject(int index) {
        return this.objectArray.get(index);
    }

    public MetaGridColumnGroup getParentGroup() {
        return this.parentGroup;
    }

    public void setLeftColumn(int leftColumn) {
        this.leftColumn = leftColumn;
    }

    public int getLeftColumn() {
        return this.leftColumn;
    }

    public void setRightColumn(int rightColumn) {
        this.rightColumn = rightColumn;
    }

    public int getRightColumn() {
        return this.rightColumn;
    }

    public boolean isInRange(int index) {
        return index >= this.leftColumn && index <= this.rightColumn;
    }

    @Override
    public void printDebugInfo(int level) {
        LogSvr.getInstance().info("column group\t" + level);
        Iterator<IMetaGridColumnObject> it = this.objectArray.iterator();
        IMetaGridColumnObject columnObject = null;
        while (it.hasNext()) {
            columnObject = it.next();
            columnObject.printDebugInfo(level + 1);
        }
    }

    @Override
    public int getObjectType() {
        return 1;
    }

    @Override
    public void getAll(int objectType, ArrayList<IMetaGridColumnObject> list) {
        Iterator<IMetaGridColumnObject> it = this.objectArray.iterator();
        IMetaGridColumnObject column = null;
        while (it.hasNext()) {
            column = it.next();
            if (column.getObjectType() == objectType) {
                list.add(column);
            }
            column.getAll(objectType, list);
        }
    }

    @Override
    public AbstractMetaObject clone() {
        return null;
    }

    @Override
    public AbstractMetaObject newInstance() {
        return null;
    }

    public void setExpandRowIndex(int expandRowIndex) {
        this.expandRowIndex = expandRowIndex;
    }

    public int getExpandRowIndex() {
        return this.expandRowIndex;
    }

    public void setExpandColumnIndex(int expandColumnIndex) {
        this.expandColumnIndex = expandColumnIndex;
    }

    public int getExpandColumnIndex() {
        return this.expandColumnIndex;
    }

    public void setExpandCell(MetaGridCell expandCell) {
        this.expandCell = expandCell;
    }

    public MetaGridCell getExpandCell() {
        return this.expandCell;
    }
}

