/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yigo.meta.factory;

import com.bokesoft.yigo.meta.base.IConfigResolver;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.List;

public class DefaultConfigResolver
implements IConfigResolver {
    @Override
    public InputStream read(String parentPath, String prefix, String resource, int type) throws Exception {
        File f = new File(this.getPath(parentPath, prefix, resource));
        if (f.isDirectory() || !f.exists()) {
            return null;
        }
        return new FileInputStream(f);
    }

    @Override
    public boolean write(String parentPath, String prefix, String resource, byte[] data) throws Exception {
        File f = new File(this.getPath(parentPath, prefix, resource));
        if (!f.exists()) {
            f.createNewFile();
        }
        FileOutputStream out = new FileOutputStream(f);
        out.write(data);
        out.close();
        return true;
    }

    @Override
    public int listResource(String parentPath, String prefix, String resource, String flag, List<String> resources, List<String> names, List<Boolean> flags) throws Exception {
        File f = new File(this.getPath(parentPath, prefix, resource));
        File[] files = f.listFiles();
        if (files != null) {
            int length = files.length;
            File childFile = null;
            for (int i = 0; i < length; ++i) {
                childFile = files[i];
                resources.add(childFile.getName());
                names.add(childFile.getName());
                if (childFile.isDirectory()) {
                    flags.add(true);
                    continue;
                }
                flags.add(false);
            }
        }
        return resources.size();
    }

    @Override
    public String getPath(String parentPath, String prefix, String resource) {
        return parentPath + prefix + File.separatorChar + resource;
    }
}

