/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yigo.meta.diff.util;

import com.bokesoft.yes.meta.persist.dom.MetaActionMap;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;
import com.bokesoft.yigo.meta.base.IMetaEnv;
import com.bokesoft.yigo.meta.diff.MetaDiff;
import com.bokesoft.yigo.meta.diff.impl.IDiffAction;
import com.bokesoft.yigo.meta.diff.impl.IDiffActionMap;
import com.bokesoft.yigo.meta.diff.impl.IDiffContext;
import com.bokesoft.yigo.meta.diff.impl.IDiffContextFactory;
import com.bokesoft.yigo.meta.diff.impl.IDiffFactoryBuilder;
import com.bokesoft.yigo.meta.diff.impl.IDiffMetaActionMapFactory;
import com.bokesoft.yigo.meta.diff.impl.IDiffMetaEnv;
import com.bokesoft.yigo.meta.diff.impl.IMetaElementFactory;

public class DiffActionManager {
    private static String DIFF_FACTORY_BUILDER = "com.bokesoft.yigo.meta.diff.base.DiffFactoryBuilder";
    private static DiffActionManager instance = new DiffActionManager();
    private IDiffFactoryBuilder factoryBuilder = null;
    private IDiffActionMap actionFactory = null;
    private IDiffContextFactory contextFactory = null;
    private IMetaElementFactory elementFactory = null;
    private IDiffMetaActionMapFactory metaActionMapFactory = null;

    private DiffActionManager() {
        this.init();
    }

    private void init() {
        try {
            this.factoryBuilder = (IDiffFactoryBuilder)Class.forName(DIFF_FACTORY_BUILDER).newInstance();
            this.actionFactory = this.factoryBuilder.buildDiffActionFactory();
            this.contextFactory = this.factoryBuilder.buildContextFactory();
            this.elementFactory = this.factoryBuilder.buildMetaElementFactory();
            this.metaActionMapFactory = this.factoryBuilder.buildMetaActionMap();
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
    }

    public boolean isInited() {
        return this.factoryBuilder != null;
    }

    public MetaActionMap getMetaActionInstance(Class<?> cls) {
        if (this.metaActionMapFactory == null) {
            return null;
        }
        return this.metaActionMapFactory.getMetaActionInstance(cls);
    }

    public AbstractMetaObject createMetaElement(String tagName, IMetaEnv env) {
        if (this.elementFactory != null) {
            return this.elementFactory.create(tagName, env);
        }
        return null;
    }

    public <T extends AbstractMetaObject> void doDiffDivideAction(String key, T oldMeta, T newMeta, MetaDiff metaDiff, IDiffMetaEnv env) throws Exception {
        if (this.actionFactory == null || oldMeta == null) {
            return;
        }
        IDiffContext context = this.contextFactory.createDiffContext(oldMeta, this.actionFactory, env);
        IDiffAction<AbstractMetaObject> diffAction = this.actionFactory.getDiffAction(oldMeta);
        if (diffAction != null) {
            diffAction.doDivide(key, oldMeta, newMeta, metaDiff, null, null, context);
        }
    }

    public <T extends AbstractMetaObject> void doDiffMergeAction(T baseMeta, MetaDiff metaDiff, IMetaEnv env) throws Exception {
        if (baseMeta == null || metaDiff == null || this.actionFactory == null) {
            return;
        }
        IDiffContext context = this.contextFactory.createDiffContext(baseMeta, this.actionFactory, env);
        IDiffAction<AbstractMetaObject> diffAction = this.actionFactory.getDiffAction(baseMeta);
        if (diffAction != null) {
            diffAction.doMerge(metaDiff, baseMeta, null, null, context);
        }
    }

    public static DiffActionManager getInstance() {
        return instance;
    }
}

