/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yigo.meta.datamigration.calculate;

import com.bokesoft.yes.meta.datamigration.calculate.MetaMigrationParas;
import com.bokesoft.yigo.meta.datamigration.MetaDMSourceField;
import com.bokesoft.yigo.meta.datamigration.MetaDataMigration;
import com.bokesoft.yigo.meta.datamigration.calculate.MetaColumnM;
import com.bokesoft.yigo.meta.datamigration.calculate.MetaMigrationTable;
import com.bokesoft.yigo.meta.datamigration.calculate.MetaPeriodColumn;
import com.bokesoft.yigo.meta.dataobject.MetaMigrationCheckRule;
import com.bokesoft.yigo.meta.factory.IMetaFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;

public class MetaMigrationTableParas {
    private MetaMigrationTable migrationTable = null;
    private TreeMap<String, MetaColumnM> assignColumnMap = new TreeMap();
    private TreeMap<String, MetaColumnM> addColumnMap = new TreeMap();

    public MetaMigrationTableParas(MetaMigrationTable migrationTable) {
        this.migrationTable = migrationTable;
    }

    public void init(MetaDataMigration migration, IMetaFactory factory) throws Throwable {
        MetaMigrationParas paras = migration.getMigrationParas(factory);
        for (MetaColumnM column : this.migrationTable.getDataColumnList()) {
            MetaDMSourceField sourceField = paras.getFieldMap().get(column.getKey());
            if (sourceField == null) continue;
            if (sourceField.getOpSign() == 2) {
                this.assignColumnMap.put(column.getKey(), column);
                if (this.addColumnMap.remove(column.getKey()) == null) continue;
                continue;
            }
            this.addColumnMap.put(column.getKey(), column);
            if (this.assignColumnMap.remove(column.getKey()) == null) continue;
        }
    }

    public TreeMap<String, MetaColumnM> getAssignColumnMap() {
        return this.assignColumnMap;
    }

    public TreeMap<String, MetaColumnM> getAddColumnMap() {
        return this.addColumnMap;
    }

    public MetaPeriodColumn getPeriodColumn() {
        return this.migrationTable.getPeriodColumn();
    }

    public ArrayList<MetaColumnM> getGroupColumnList() {
        return this.migrationTable.getGroupColumnList();
    }

    public ArrayList<MetaColumnM> getDataColumnList() {
        return this.migrationTable.getDataColumnList();
    }

    public String getTag() {
        return this.migrationTable.getTag();
    }

    public int getMigrationUpdateStrategy() {
        return this.migrationTable.getMigrationUpdateStrategy();
    }

    public List<MetaMigrationCheckRule> getCheckRuleList() {
        return this.migrationTable.getCheckRuleList();
    }
}

