/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yigo.meta.datamap.calculate;

import com.bokesoft.yes.meta.i18n.StringTable;
import com.bokesoft.yigo.common.util.SimpleStringFormat;
import com.bokesoft.yigo.meta.base.MetaException;
import com.bokesoft.yigo.meta.datamap.MetaMap;
import com.bokesoft.yigo.meta.datamap.source.MetaSourceTable;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import java.util.ArrayList;
import java.util.HashMap;

public class MetaMapEdge {
    private String sourceTableKey;
    private String targetTableKey;
    private ArrayList<String> sourceTableList = null;
    private ArrayList<String> targetTableList = null;
    private HashMap<String, MetaMapEdge> childEdgeMap = new HashMap();
    private boolean mainTableParent = false;

    public MetaMapEdge(String sourceTableKey) {
        this.sourceTableKey = sourceTableKey;
    }

    public void searchEdgeMap(MetaMap dataMap, MetaDataObject srcDataObject, MetaDataObject tgtDataObject) {
        MetaSourceTable sourceTable = (MetaSourceTable)dataMap.getSourceTableCollection().get(this.sourceTableKey);
        if (sourceTable == null) {
            throw new MetaException(68, SimpleStringFormat.format((String)StringTable.getString(null, "", "MapPrimaryTableNotSet"), (Object[])new Object[]{dataMap.getKey()}));
        }
        this.targetTableKey = sourceTable.getTargetTableKey();
        this.sourceTableList = this.searchTableList(srcDataObject, this.sourceTableKey);
        this.targetTableList = this.searchTableList(tgtDataObject, this.targetTableKey);
    }

    private ArrayList<String> searchTableList(MetaDataObject dataObject, String tableKey) {
        ArrayList<String> orginList = new ArrayList<String>();
        while (tableKey != null && tableKey.length() > 0) {
            orginList.add(0, tableKey);
            tableKey = dataObject.getMetaTable(tableKey).getParentKey();
        }
        return orginList;
    }

    public ArrayList<String> getSourceTableList() {
        return this.sourceTableList;
    }

    public ArrayList<String> getTargetTableList() {
        return this.targetTableList;
    }

    public void putChildEdgeList(MetaMapEdge edge) {
        this.childEdgeMap.put(edge.getSourceTableKey(), edge);
    }

    public String getSourceTableKey() {
        return this.sourceTableKey;
    }

    public HashMap<String, MetaMapEdge> getChildEdgeMap() {
        return this.childEdgeMap;
    }

    public String getTargetTableKey() {
        return this.targetTableKey;
    }

    public boolean isMainTableParent() {
        return this.mainTableParent;
    }

    public void setMainTableParent(boolean mainTableParent) {
        this.mainTableParent = mainTableParent;
    }
}

