/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.meta.persist.dom.xml.defaultnode;

import com.bokesoft.yes.common.util.StringUtil;
import com.bokesoft.yes.meta.persist.dom.xml.defaultnode.DefaultNode;
import com.bokesoft.yes.meta.persist.dom.xml.defaultnode.DefaultNodeCollection;
import com.bokesoft.yes.meta.persist.dom.xml.defaultnode.LinkedData;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DefaultNodeDefine {
    private static final String ATTRIBUTE_ATTRS = "Attrs";
    private static final String ATTRIBUTE_PRIMARYKEY = "PrimaryKey";
    private static final String ATTRIBUTE_ISSINGLE = "IsSingle";
    public static final String NODE_COMMENT = "!-- -->";
    public static final String NODE_CDATA = "![CDATA[ ]]>";
    private DefaultNodeCollection nodeCollection = new DefaultNodeCollection();
    private static DefaultNodeDefine instance = null;

    private DefaultNodeDefine() {
        this.load();
        this.nodeCollection.setNode(NODE_COMMENT, new DefaultNode(NODE_COMMENT, true));
        this.nodeCollection.setNode(NODE_CDATA, new DefaultNode(NODE_CDATA, true));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load() {
        InputStream in = null;
        try {
            in = DefaultNodeDefine.class.getResourceAsStream("XmlNodeDefine.xml");
            Document document = null;
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            document = builder.parse(in);
            Element rootElement = document.getDocumentElement();
            this.trans(rootElement, "", "");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public DefaultNode getDefaultNode(String tagName) {
        return this.nodeCollection.getNode(tagName);
    }

    public String getPrimaryKey(String tagName) {
        DefaultNode node = this.getDefaultNode(tagName);
        if (node != null) {
            return node.getPrimaryKey();
        }
        return "Key";
    }

    private void trans(Element elem, String sParentAttrs, String primaryKey) {
        primaryKey = StringUtil.isEmptyStr((String)elem.getAttribute(ATTRIBUTE_PRIMARYKEY)) ? primaryKey : elem.getAttribute(ATTRIBUTE_PRIMARYKEY);
        String allAttrs = this.getAllAttrs(elem, sParentAttrs);
        if (elem.hasChildNodes()) {
            NodeList childNodes = elem.getChildNodes();
            int len = childNodes.getLength();
            for (int i = 0; i < len; ++i) {
                Node childNode = childNodes.item(i);
                if (!(childNode instanceof Element)) continue;
                this.trans((Element)childNode, allAttrs, primaryKey);
            }
        } else {
            this.createDefaultNode(elem, allAttrs, primaryKey);
        }
    }

    private void createDefaultNode(Element elem, String sParentAttrs, String primaryKey) {
        primaryKey = StringUtil.isEmptyStr((String)elem.getAttribute(ATTRIBUTE_PRIMARYKEY)) ? primaryKey : elem.getAttribute(ATTRIBUTE_PRIMARYKEY);
        String allAttrs = this.getAllAttrs(elem, sParentAttrs);
        String[] attrs = allAttrs.split(",");
        String tagName = elem.getTagName();
        DefaultNode node = new DefaultNode(tagName);
        node.setPrimaryKey(primaryKey);
        for (String attr : attrs) {
            node.addNode(new LinkedData(attr));
        }
        boolean isSingle = StringUtil.isEmptyStr((String)elem.getAttribute(ATTRIBUTE_ISSINGLE)) ? false : Boolean.valueOf(elem.getAttribute(ATTRIBUTE_ISSINGLE));
        node.setSingle(isSingle);
        this.nodeCollection.setNode(tagName, node);
    }

    private String getAllAttrs(Element elem, String sParentAttrs) {
        String allAttrs = "";
        String attrs = elem.getAttribute(ATTRIBUTE_ATTRS);
        allAttrs = StringUtil.isEmptyStr((String)sParentAttrs) && StringUtil.isEmptyStr((String)attrs) ? "" : (StringUtil.isEmptyStr((String)sParentAttrs) ? attrs : (StringUtil.isEmptyStr((String)attrs) ? sParentAttrs : sParentAttrs + "," + attrs));
        return allAttrs;
    }

    public static synchronized DefaultNodeDefine getInstance() {
        if (instance == null) {
            instance = new DefaultNodeDefine();
        }
        return instance;
    }

    public String[] getPopupArray(List<String> filters) {
        return this.nodeCollection.getNodenames();
    }
}

