/*
 * Decompiled with CFR 0.152.
 */
package com.bokesoft.yes.meta.persist.dom.solution;

import com.bokesoft.yes.meta.persist.dom.solution.BaseMetaScanLoad;
import com.bokesoft.yigo.meta.base.IMetaResolver;
import com.bokesoft.yigo.meta.report.MetaReportList;
import com.bokesoft.yigo.meta.report.MetaReportProfile;
import com.bokesoft.yigo.meta.report.MetaReportSubList;
import com.bokesoft.yigo.meta.solution.MetaProject;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.json.JSONObject;

public class MetaReportScanLoad
extends BaseMetaScanLoad {
    private MetaReportList reportList = null;
    List<MetaReportProfile> list = null;

    public MetaReportScanLoad(MetaReportList reportList, IMetaResolver resolver, MetaProject metaProject, Object context) {
        super(resolver, metaProject, "Report", context);
        this.reportList = reportList;
        this.list = new CopyOnWriteArrayList<MetaReportProfile>();
    }

    @Override
    protected void postLoad() throws Throwable {
        super.postLoad();
        this.merge();
    }

    @Override
    public void loadMetaData(Object parent, String parentPath, String filePath, String fileName) throws Exception {
        String tagName;
        JSONObject profileInfo = this.resolver.readProfile(filePath, 0);
        if (profileInfo != null && "Report".equals(tagName = profileInfo.optString("TagName"))) {
            MetaReportProfile profile = new MetaReportProfile();
            profile.setKey(profileInfo.optString("Key"));
            profile.setCaption(profileInfo.optString("Caption"));
            profile.setFormKey(profileInfo.optString("FormKey"));
            String s = profileInfo.optString("Group");
            profile.setGroup(s == null ? "" : s);
            s = profileInfo.optString("Default");
            if (s != null && !s.isEmpty()) {
                profile.setDefault(Boolean.parseBoolean(s));
            }
            profile.setProject(this.metaProject);
            profile.setResource(filePath);
            this.doFind(parent, parentPath, filePath, fileName, profile);
            this.list.add(profile);
        }
    }

    protected void doFind(Object parent, String parentPath, String filePath, String fileName, MetaReportProfile profile) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void merge() {
        if (this.list.isEmpty()) {
            return;
        }
        try {
            for (MetaReportProfile profile : this.list) {
                String formKey = profile.getFormKey();
                MetaReportSubList subList = (MetaReportSubList)this.reportList.get(formKey);
                if (subList == null) {
                    subList = new MetaReportSubList();
                    subList.setKey(formKey);
                }
                subList.add(profile);
                this.reportList.add(subList);
            }
        }
        finally {
            this.list.clear();
        }
    }

    public MetaReportList getMetaReportList() {
        this.merge();
        return this.reportList;
    }
}

