package com.bokesoft.yigo.meta.taskflow.node;

import com.bokesoft.yes.meta.persist.dom.taskflow.NodeType;
import com.bokesoft.yigo.meta.base.AbstractMetaObject;

/**
 * 节点状态
 */
public class MetaState extends MetaNode {

	public final static String TAG_NAME = "State";
	
	/**
	 * 节点状态值
	 */
	private String status = null;
	
	/**
	 * 设置状态值
	 * @param s 状态值
	 */
	public void setStatus(String s) {
		this.status = s;
	}
	
	/**
	 * 获取状态值
	 * @return 状态值
	 */
	public String getStatus() {
		return this.status;
	}
	
	@Override
	public String getTagName() {
		return TAG_NAME;
	}

	@Override
	public int getNodeType() {
		return NodeType.STATE;
	}

	@Override
	public AbstractMetaObject newInstance() {
		return new MetaStart();
	}
	
	@Override
	public AbstractMetaObject clone() {
		MetaState clone = (MetaState) super.clone();
		clone.setStatus(status);
		return clone;
	}
}
