package com.bokesoft.yigo.meta.taskflow;

import com.bokesoft.yigo.common.def.DataObjectPrimaryType;
import com.bokesoft.yigo.common.def.DataType;
import com.bokesoft.yigo.common.def.TableMode;
import com.bokesoft.yigo.common.def.TableSourceType;
import com.bokesoft.yigo.meta.dataobject.MetaColumn;
import com.bokesoft.yigo.meta.dataobject.MetaDataObject;
import com.bokesoft.yigo.meta.dataobject.MetaTable;
import com.bokesoft.yigo.meta.dataobject.MetaTableCollection;

public class TaskFlowDataObjectCreator {

	public static final MetaDataObject getDataObject() throws Throwable {
		
		MetaDataObject taskFlowDataObject = new MetaDataObject();
		taskFlowDataObject.setAutoGen(true);
		taskFlowDataObject.setKey("SystemTaskFlow");
		taskFlowDataObject.setPrimaryType(DataObjectPrimaryType.ENTITY);
		MetaTableCollection tableCollection = new MetaTableCollection();
		taskFlowDataObject.setCaption("");
		taskFlowDataObject.setTableCollection(tableCollection);
		
		MetaTable flowInstance = createTable(taskFlowDataObject, "TF_FlowInstance");
		addColumn(flowInstance, "TaskFlowId", DataType.STRING, 255).setPrimaryKey(true);
		addColumn(flowInstance, "TaskFlowKey", DataType.STRING, 50);
		//addColumn(flowInstance, "OID", DataType.STRING, 50);
		//addColumn(flowInstance, "DataObjectKey", DataType.STRING, 50);
		//addColumn(flowInstance, "Document", DataType.TEXT, 0);
		addColumn(flowInstance, "Paras", DataType.TEXT, 0);
		
		MetaTable taskInstance = createTable(taskFlowDataObject, "TF_TaskInstance");
		addColumn(taskInstance, "TaskId", DataType.STRING, 255).setPrimaryKey(true);
		addColumn(taskInstance, "TaskKey", DataType.STRING, 50);
		addColumn(taskInstance, "Paras", DataType.TEXT, 0);
		addColumn(taskInstance, "TaskFlowId", DataType.STRING, 255);
		addColumn(taskInstance, "TaskFlowKey", DataType.STRING, 50);
		addColumn(taskInstance, "OID", DataType.LONG, 0);
		addColumn(taskInstance, "DataObjectKey", DataType.STRING, 50);
		addColumn(taskInstance, "Document", DataType.TEXT, 0);
		addColumn(taskInstance, "FlowParas", DataType.TEXT, 0);
		
		return taskFlowDataObject;
	}
	
	private static MetaTable createTable(MetaDataObject dataObject, String key) {
		MetaTable table = new MetaTable();
		table.setKey(key);
		table.setCaption("");
		table.setDBTableName("");
		table.setFilter(null);
		table.setSourceType(TableSourceType.DATAOBJECT);
		table.setTableMode(TableMode.DETAIL);
		return dataObject.getTableCollection().add(table);
	}
	
	private static MetaColumn addColumn(MetaTable table, String key, int dataType, int length) {
		return _addColumn(table, key, dataType, length, true, false);
	}
	
	private static MetaColumn _addColumn(MetaTable table, String key, int dataType, int length, boolean persist, boolean ignoreQuery) {
		MetaColumn column = new MetaColumn();
		column.setKey(key);
		column.setCaption("");
		column.setPersist(persist);
		column.setIgnoreQuery(ignoreQuery);
		column.setDefaultValue("");
		column.setDescription("");
		column.setDBColumnName("");
		column.setDataType(dataType);
		column.setLength(length);
		column.setAutoGen(true);
		table.add(column);
		return column;
	}
}
